/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_pointIndexListToMesh")
public class PointIndexListToMesh
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Pointlist";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getParameterHelpText() {
        return "Image pointlist, Image indexlist, ByRef Image mesh_destination";
    }

    public boolean executeCL() {
        ClearCLBuffer pointlist = (ClearCLBuffer)this.args[0];
        ClearCLBuffer indexList = (ClearCLBuffer)this.args[1];
        ClearCLBuffer mesh = (ClearCLBuffer)this.args[2];
        return this.getCLIJ2().pointIndexListToMesh(pointlist, indexList, mesh);
    }

    public static boolean pointIndexListToMesh(CLIJ2 clij2, ClearCLBuffer pointlist, ClearCLBuffer indexlist, ClearCLBuffer mesh) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src_pointlist", pointlist);
        parameters.put("src_indexlist", indexlist);
        parameters.put("dst_mesh", mesh);
        long[] dimensions = new long[]{indexlist.getDimensions()[0], 1L, 1L};
        clij2.activateSizeIndependentKernelCompilation();
        clij2.execute(PointIndexListToMesh.class, "pointindexlist_to_mesh_3d_x.cl", "pointindexlist_to_mesh_3d", dimensions, dimensions, parameters);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        ClearCLBuffer pointlist = (ClearCLBuffer)this.args[0];
        CLIJ2 clij2 = this.getCLIJ2();
        ClearCLBuffer temp = clij2.create(new long[]{1L, pointlist.getHeight()}, NativeTypeEnum.UnsignedShort);
        clij2.maximumXProjection((ClearCLImageInterface)input, (ClearCLImageInterface)temp);
        short[] array = new short[(int)temp.getHeight()];
        ShortBuffer buffer = ShortBuffer.wrap(array);
        temp.writeTo((Buffer)buffer, true);
        clij2.release((ClearCLImageInterface)temp);
        long[] dimensions = new long[array.length];
        for (int d = 0; d < array.length; ++d) {
            dimensions[d] = array[d];
        }
        return clij2.create(dimensions, input.getNativeType());
    }

    public String getDescription() {
        return "Meshes all points in a given point list which are indiced in a corresponding index list.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Graph, Visualisation";
    }
}

