/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_pointlistToLabelledSpots")
public class PointlistToLabelledSpots
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Pointlist";
    }

    @Override
    public String getOutputType() {
        return "Label Image";
    }

    public String getParameterHelpText() {
        return "Image pointlist, ByRef Image spots_destination";
    }

    public boolean executeCL() {
        ClearCLBuffer pointlist = (ClearCLBuffer)this.args[0];
        ClearCLBuffer labelledSpots = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().pointlistToLabelledSpots(pointlist, labelledSpots);
    }

    public static boolean pointlistToLabelledSpots(CLIJ2 clij2, ClearCLBuffer pointlist, ClearCLBuffer labelledSpots) {
        ClearCLBuffer ramp = clij2.create(pointlist.getWidth(), pointlist.getHeight() + 1L);
        ClearCLBuffer temp = clij2.create(pointlist.getWidth(), pointlist.getHeight() + 1L);
        clij2.setRampX((ClearCLImageInterface)ramp);
        clij2.addImageAndScalar((ClearCLImageInterface)ramp, (ClearCLImageInterface)temp, 1.0);
        clij2.paste((ClearCLImageInterface)pointlist, (ClearCLImageInterface)temp, 0.0, 0.0);
        clij2.writeValuesToPositions(temp, labelledSpots);
        ramp.close();
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        ClearCLBuffer pointlist = (ClearCLBuffer)this.args[0];
        CLIJ2 clij2 = this.getCLIJ2();
        ClearCLBuffer temp = clij2.create(new long[]{1L, pointlist.getHeight()}, NativeTypeEnum.UnsignedShort);
        clij2.maximumXProjection((ClearCLImageInterface)input, (ClearCLImageInterface)temp);
        short[] array = new short[(int)temp.getHeight()];
        ShortBuffer buffer = ShortBuffer.wrap(array);
        temp.writeTo((Buffer)buffer, true);
        clij2.release((ClearCLImageInterface)temp);
        long[] dimensions = new long[array.length];
        for (int d = 0; d < array.length; ++d) {
            dimensions[d] = array[d];
        }
        return clij2.create(dimensions, input.getNativeType());
    }

    public String getDescription() {
        return "Takes a pointlist with dimensions n times d with n point coordinates in d dimensions and labels corresponding pixels.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Label";
    }
}

