/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_powerImages")
public class PowerImages
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().powerImages((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2]);
        return result;
    }

    public static boolean powerImages(CLIJ2 clij2, ClearCLBuffer input1, ClearCLBuffer input2, ClearCLBuffer output) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src1", input1);
        parameters.put("src2", input2);
        parameters.put("dst", output);
        clij2.execute(PowerImages.class, "power_images_" + input1.getDimension() + "d_x.cl", "power_images_" + input1.getDimension() + "d", output.getDimensions(), output.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image input, Image exponent, ByRef Image destination";
    }

    public String getDescription() {
        return "Calculates x to the power of y pixel wise of two images X and Y.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDimensions(), NativeTypeEnum.Float);
    }
}

