/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import ij.WindowManager;
import ij.process.ImageProcessor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_pullToCurrentSlice")
public class PullToCurrentSlice
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public String getParameterHelpText() {
        return "Image input_slice, String target_image_stack";
    }

    public boolean executeCL() {
        ClearCLBuffer slice = (ClearCLBuffer)this.args[0];
        ImagePlus imp = WindowManager.getImage((String)((String)this.args[1]));
        PullToCurrentSlice.pullToCurrentSlice(this.getCLIJ2(), slice, imp);
        return true;
    }

    public static void pullToCurrentSlice(CLIJ2 clij2, ClearCLBuffer input, ImagePlus target) {
        ImageProcessor ip = target.getProcessor();
        if (input.getWidth() == (long)target.getWidth() && input.getHeight() == (long)target.getHeight()) {
            if (input.getNativeType() == NativeTypeEnum.Float && ip.getBitDepth() == 32) {
                input.writeTo((Buffer)FloatBuffer.wrap((float[])ip.getPixels()), true);
                target.updateAndDraw();
                return;
            }
            if (input.getNativeType() == NativeTypeEnum.UnsignedShort && ip.getBitDepth() == 16) {
                input.writeTo((Buffer)ShortBuffer.wrap((short[])ip.getPixels()), true);
                target.updateAndDraw();
                return;
            }
            if (input.getNativeType() == NativeTypeEnum.UnsignedByte && ip.getBitDepth() == 8) {
                input.writeTo((Buffer)ByteBuffer.wrap((byte[])ip.getPixels()), true);
                target.updateAndDraw();
                return;
            }
        }
        ClearCLBuffer currentSlice = clij2.pushCurrentSlice(target);
        clij2.paste((ClearCLImageInterface)input, (ClearCLImageInterface)currentSlice, 0.0, 0.0);
        ImagePlus imp = clij2.pull(currentSlice);
        target.setProcessor(imp.getProcessor());
        currentSlice.close();
    }

    public String getDescription() {
        return "Pulls a two dimensional image from the GPU memory and enters it in the current/given image stack at the selected slice.\n\nIf image type and/or dimensions don't fit a paste operation will be performed in the background, this may limit performance.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

