/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_pushResultsTableColumn")
public class PushResultsTableColumn
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public boolean executeCL() {
        ClearCLBuffer buffer = (ClearCLBuffer)this.args[0];
        String column = (String)this.args[1];
        ResultsTable table = ResultsTable.getResultsTable();
        this.getCLIJ2().pushResultsTableColumn(buffer, table, column);
        return true;
    }

    public static boolean pushResultsTableColumn(CLIJ2 clij2, ClearCLBuffer buffer, ResultsTable table, String column) {
        ClearCLBuffer temp = clij2.create(new long[]{table.getCounter(), 1L, 1L}, NativeTypeEnum.Float);
        float[] columnData = table.getColumn(table.getColumnIndex(column));
        FloatBuffer arrayBuffer = FloatBuffer.wrap(columnData);
        temp.readFrom((Buffer)arrayBuffer, true);
        clij2.copy((ClearCLImageInterface)temp, (ClearCLImageInterface)buffer);
        temp.close();
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        ResultsTable table = ResultsTable.getResultsTable();
        return this.clij.create(new long[]{table.getCounter(), 1L, 1L}, NativeTypeEnum.Float);
    }

    public String getParameterHelpText() {
        return "ByRef Image destination, String column_name";
    }

    public String getDescription() {
        return "Converts a table column to an image. \n\nThe values are stored in x dimension.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

