/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_pushString")
public class PushString
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public boolean executeCL() {
        ClearCLBuffer buffer = (ClearCLBuffer)this.args[0];
        String image = (String)this.args[1];
        this.getCLIJ2().pushString(buffer, image);
        return true;
    }

    public static boolean pushString(CLIJ2 clij2, ClearCLBuffer buffer, String image) {
        ImageStack stack = new ImageStack();
        int depth = image.split("\n\n").length;
        int height = image.split("\n\n")[0].split("\n").length;
        int width = image.split("\n\n")[0].split("\n")[0].split(" ").length;
        String[] slices = image.split("\n\n");
        for (int z = 0; z < depth; ++z) {
            String slice = slices[z];
            String[] lines = slice.split("\n");
            FloatProcessor fp = new FloatProcessor(width, height);
            float[] array = (float[])fp.getPixels();
            for (int y = 0; y < lines.length; ++y) {
                String line = lines[y];
                String[] numbers = line.split(" ");
                for (int x = 0; x < numbers.length; ++x) {
                    array[x + y * width] = Float.parseFloat(numbers[x]);
                }
            }
            stack.addSlice((ImageProcessor)fp);
        }
        ImagePlus imp = new ImagePlus("", stack);
        ClearCLBuffer converted = clij2.push(imp);
        clij2.copy((ClearCLImageInterface)converted, (ClearCLImageInterface)buffer);
        converted.close();
        return true;
    }

    public static ClearCLBuffer pushString(CLIJ2 clij2, String image) {
        int depth = image.split("\n\n").length;
        int height = image.split("\n\n")[0].split("\n").length;
        int width = image.split("\n\n")[0].split("\n")[0].split(" ").length;
        ClearCLBuffer buffer = depth > 1 ? clij2.create(new long[]{width, height, depth}, NativeTypeEnum.Float) : clij2.create(new long[]{width, height}, NativeTypeEnum.Float);
        PushString.pushString(clij2, buffer, image);
        return buffer;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        String image = (String)this.args[1];
        int depth = image.split("\n\n").length;
        int height = image.split("\n\n")[0].split("\n").length;
        int width = image.split("\n\n")[0].split("\n")[0].split(" ").length;
        if (depth > 1) {
            return this.clij.create(new long[]{width, height, depth}, NativeTypeEnum.Float);
        }
        return this.clij.create(new long[]{width, height}, NativeTypeEnum.Float);
    }

    public String getParameterHelpText() {
        return "ByRef Image destination, String input, Number width, Number height, Number depth";
    }

    public String getDescription() {
        return "Converts an string to an image. \n\nThe formatting works with double line breaks for slice switches, single line breaks for y swithces and \nspaces for x. For example this string is converted to an image with width=4, height=3 and depth=2:\n\n1 2 3 4\n5 6 7 8\n9 0 1 2\n\n3 4 5 6\n7 8 9 0\n1 2 3 4\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

