/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_reduceStack")
public class ReduceStack
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 2, 0};
    }

    public boolean executeCL() {
        return this.getCLIJ2().reduceStack((ClearCLImageInterface)this.args[0], (ClearCLImageInterface)this.args[1], ReduceStack.asInteger((Object)this.args[2]).intValue(), ReduceStack.asInteger((Object)this.args[3]).intValue());
    }

    public static boolean reduceStack(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst, Integer factor, Integer offset) {
        ClearCLBuffer temp = clij2.create(new long[]{src.getWidth(), src.getHeight()}, src.getNativeType());
        int j = 0;
        int i = 0;
        while ((long)i < src.getDepth()) {
            clij2.copySlice(src, (ClearCLImageInterface)temp, i + offset);
            clij2.copySlice((ClearCLImageInterface)temp, dst, j);
            ++j;
            i += factor.intValue();
        }
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int factor = ReduceStack.asInteger((Object)this.args[2]);
        return this.getCLIJ2().create(new long[]{input.getWidth(), input.getHeight(), input.getDepth() / (long)factor}, input.getNativeType());
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number reduction_factor, Number offset";
    }

    public String getDescription() {
        return "Reduces the number of slices in a stack by a given factor.\nWith the offset you have control which slices stay: \n* With factor 3 and offset 0, slices 0, 3, 6,... are kept. * With factor 4 and offset 1, slices 1, 5, 9,... are kept.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

