/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_replacePixelsIfZero")
public class ReplacePixelsIfZero
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public boolean executeCL() {
        return ReplacePixelsIfZero.replacePixelsIfZero(this.getCLIJ2(), (ClearCLImageInterface)this.args[0], (ClearCLImageInterface)this.args[1], (ClearCLImageInterface)this.args[2]);
    }

    public static boolean replacePixelsIfZero(CLIJ2 clij2, ClearCLImageInterface src1, ClearCLImageInterface src2, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src1, (Object)dst);
        CLIJUtilities.assertDifferent((Object)src2, (Object)dst);
        CLIJUtilities.assertDifferent((Object)src2, (Object)src1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src1", src1);
        parameters.put("src2", src2);
        parameters.put("dst", dst);
        clij2.execute(ReplacePixelsIfZero.class, "replace_pixels_if_zero_x.cl", "replace_pixels_if_zero", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image input1, Image input2, ByRef Image destination";
    }

    public String getDescription() {
        return "Replaces pixel values x with y in case x is zero.\n\nThis functionality is comparable to ImageJs image calculator operator 'transparent zero'.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Filter";
    }
}

