/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_resample")
public class Resample
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0, 0, 0, true};
    }

    public boolean executeCL() {
        float factorX = Resample.asFloat((Object)this.args[2]).floatValue();
        float factorY = Resample.asFloat((Object)this.args[3]).floatValue();
        float factorZ = Resample.asFloat((Object)this.args[4]).floatValue();
        boolean linearInterpolation = Resample.asBoolean((Object)this.args[5]);
        boolean result = this.getCLIJ2().resample((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]), factorX, factorY, factorZ, linearInterpolation);
        return result;
    }

    @Deprecated
    public static boolean resample(CLIJ2 clij2, ClearCLImageInterface input, ClearCLImageInterface output, Float factorX, Float factorY, Float factorZ, Boolean linearInterpolation) {
        if (input.getDimension() == 3L) {
            return Resample.resample3D(clij2, input, output, factorX, factorY, factorZ, linearInterpolation);
        }
        return Resample.resample2D(clij2, input, output, factorX, factorY, linearInterpolation);
    }

    public static boolean resample3D(CLIJ2 clij2, ClearCLImageInterface input, ClearCLImageInterface output, Float factorX, Float factorY, Float factorZ, Boolean linearInterpolation) {
        AffineTransform3D at = new AffineTransform3D();
        at.set((double)factorX.floatValue(), 0.0, 0.0, 0.0, 0.0, (double)factorY.floatValue(), 0.0, 0.0, 0.0, 0.0, (double)factorZ.floatValue(), 0.0);
        if (linearInterpolation.booleanValue()) {
            ClearCLImage inputImage = clij2.create(input.getDimensions(), ImageChannelDataType.Float);
            clij2.copy(input, (ClearCLImageInterface)inputImage);
            ClearCLImage outputImage = clij2.create(output.getDimensions(), ImageChannelDataType.Float);
            clij2.affineTransform3D(inputImage, (ClearCLImageInterface)outputImage, at);
            inputImage.close();
            clij2.copy((ClearCLImageInterface)outputImage, output);
            outputImage.close();
        } else if (input instanceof ClearCLBuffer && output instanceof ClearCLBuffer) {
            clij2.affineTransform3D((ClearCLBuffer)input, (ClearCLImageInterface)((ClearCLBuffer)output), at);
        } else if (input instanceof ClearCLImage && output instanceof ClearCLBuffer) {
            clij2.affineTransform3D((ClearCLImage)input, (ClearCLImageInterface)((ClearCLBuffer)output), at);
        } else if (input instanceof ClearCLImage && output instanceof ClearCLImage) {
            clij2.affineTransform3D((ClearCLImage)input, (ClearCLImageInterface)((ClearCLImage)output), at);
        } else if (input instanceof ClearCLBuffer && output instanceof ClearCLImage) {
            ClearCLBuffer temp = clij2.create(output.getDimensions(), output.getNativeType());
            clij2.affineTransform3D((ClearCLBuffer)input, (ClearCLImageInterface)temp, at);
            clij2.copy((ClearCLImageInterface)temp, output);
            clij2.release((ClearCLImageInterface)temp);
        }
        return true;
    }

    public static boolean resample2D(CLIJ2 clij2, ClearCLImageInterface input, ClearCLImageInterface output, Float factorX, Float factorY, Boolean linearInterpolation) {
        AffineTransform2D at = new AffineTransform2D();
        at.set(new double[]{factorX.floatValue(), 0.0, 0.0, 0.0, factorY.floatValue(), 0.0});
        if (linearInterpolation.booleanValue()) {
            ClearCLImage inputImage = clij2.create(input.getDimensions(), ImageChannelDataType.Float);
            clij2.copy(input, (ClearCLImageInterface)inputImage);
            ClearCLImage outputImage = clij2.create(output.getDimensions(), ImageChannelDataType.Float);
            clij2.affineTransform2D(inputImage, (ClearCLImageInterface)outputImage, at);
            inputImage.close();
            clij2.copy((ClearCLImageInterface)outputImage, output);
            outputImage.close();
        } else if (input instanceof ClearCLBuffer && output instanceof ClearCLBuffer) {
            clij2.affineTransform2D((ClearCLBuffer)input, (ClearCLImageInterface)((ClearCLBuffer)output), at);
        } else if (input instanceof ClearCLImage && output instanceof ClearCLBuffer) {
            clij2.affineTransform2D((ClearCLImage)input, (ClearCLImageInterface)((ClearCLBuffer)output), at);
        } else if (input instanceof ClearCLImage && output instanceof ClearCLImage) {
            clij2.affineTransform2D((ClearCLImage)input, (ClearCLImageInterface)((ClearCLImage)output), at);
        } else if (input instanceof ClearCLBuffer && output instanceof ClearCLImage) {
            ClearCLBuffer temp = clij2.create(output.getDimensions(), output.getNativeType());
            clij2.affineTransform2D((ClearCLBuffer)input, (ClearCLImageInterface)temp, at);
            clij2.copy((ClearCLImageInterface)temp, output);
            clij2.release((ClearCLImageInterface)temp);
        }
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        float factorX = Resample.asFloat((Object)this.args[2]).floatValue();
        float factorY = Resample.asFloat((Object)this.args[3]).floatValue();
        float factorZ = Resample.asFloat((Object)this.args[4]).floatValue();
        if (input.getDimension() == 2L) {
            return this.clij.create(new long[]{(long)((float)input.getWidth() / factorX), (long)((float)input.getHeight() / factorY)}, input.getNativeType());
        }
        return this.clij.create(new long[]{(long)((float)input.getWidth() / factorX), (long)((float)input.getHeight() / factorY), (long)((float)input.getDepth() / factorZ)}, input.getNativeType());
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number factor_x, Number factor_y, Number factor_z, Boolean linear_interpolation";
    }

    public String getDescription() {
        return "Resamples an image with given size factors using an affine transform.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

