/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_resliceRadial")
public class ResliceRadial
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().resliceRadial((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], ResliceRadial.asFloat((Object)this.args[3]).floatValue(), ResliceRadial.asFloat((Object)this.args[4]).floatValue(), ResliceRadial.asFloat((Object)this.args[5]).floatValue(), ResliceRadial.asFloat((Object)this.args[6]).floatValue(), ResliceRadial.asFloat((Object)this.args[7]).floatValue(), ResliceRadial.asFloat((Object)this.args[8]).floatValue());
        return result;
    }

    @Deprecated
    public static boolean radialProjection(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Float deltaAngle) {
        return ResliceRadial.resliceRadial(clij2, src, dst, deltaAngle, Float.valueOf(0.0f), Float.valueOf((float)src.getWidth() / 2.0f), Float.valueOf((float)src.getHeight() / 2.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
    }

    public static boolean resliceRadial(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Float deltaAngle) {
        return ResliceRadial.resliceRadial(clij2, src, dst, deltaAngle, Float.valueOf(0.0f), Float.valueOf((float)src.getWidth() / 2.0f), Float.valueOf((float)src.getHeight() / 2.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
    }

    public static boolean resliceRadial(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Float deltaAngle, Float centerX, Float centerY) {
        return ResliceRadial.resliceRadial(clij2, src, dst, deltaAngle, Float.valueOf(0.0f), centerX, centerY, Float.valueOf(1.0f), Float.valueOf(1.0f));
    }

    public static boolean resliceRadial(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst, Float deltaAngle, Float startAngleDegrees, Float centerX, Float centerY, Float scaleFactorX, Float scaleFactorY) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        ClearCLImage image = clij2.create(src.getDimensions(), ImageChannelDataType.Float);
        clij2.copy((ClearCLImageInterface)src, (ClearCLImageInterface)image);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", image);
        parameters.put("dst", dst);
        parameters.put("deltaAngle", deltaAngle);
        parameters.put("centerX", centerX);
        parameters.put("centerY", centerY);
        parameters.put("startAngleDegrees", startAngleDegrees);
        parameters.put("scaleX", scaleFactorX);
        parameters.put("scaleY", scaleFactorY);
        clij2.execute(ResliceRadial.class, "reslice_radial_interpolate_" + image.getDimension() + "d_x.cl", "reslice_radial_" + image.getDimension() + "d", dst.getDimensions(), dst.getDimensions(), parameters);
        clij2.release((ClearCLImageInterface)image);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number numberOfAngles, Number angleStepSize, Number startAngleDegrees, Number centerX, Number centerY, Number scaleFactorX, Number scaleFactorY";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int numberOfAngles = ResliceRadial.asInteger((Object)this.args[2]);
        float angleStepSize = ResliceRadial.asFloat((Object)this.args[3]).floatValue();
        int effectiveNumberOfAngles = (int)((float)numberOfAngles / angleStepSize);
        int maximumRadius = (int)Math.sqrt(Math.pow(input.getWidth() / 2L, 2.0) + Math.pow(input.getHeight() / 2L, 2.0));
        return this.getCLIJ2().create(new long[]{maximumRadius, input.getDepth(), effectiveNumberOfAngles}, input.getNativeType());
    }

    public String getDescription() {
        return "Computes a radial projection of an image stack. \n\nStarting point for the line is the given point in any \nX/Y-plane of a given input image stack. Furthermore, radius of the resulting projection must be given and scaling factors in X and Y in case pixels are not isotropic.This operation is similar to ImageJs 'Radial Reslice' method but offers less flexibility.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

