/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_resliceRadialTop")
public class ResliceRadialTop
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public boolean executeCL() {
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer result = (ClearCLBuffer)this.args[1];
        float angleStepSize = ResliceRadialTop.asFloat((Object)this.args[3]).floatValue();
        float startAngleDegrees = ResliceRadialTop.asFloat((Object)this.args[4]).floatValue();
        float centerX = ResliceRadialTop.asFloat((Object)this.args[5]).floatValue();
        float centerY = ResliceRadialTop.asFloat((Object)this.args[6]).floatValue();
        float scaleFactorX = ResliceRadialTop.asFloat((Object)this.args[7]).floatValue();
        float scaleFactorY = ResliceRadialTop.asFloat((Object)this.args[8]).floatValue();
        return this.resliceRadialTop(this.getCLIJ2(), input, result, angleStepSize, startAngleDegrees, centerX, centerY, scaleFactorX, scaleFactorY);
    }

    private boolean resliceRadialTop(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer result, float angleStepSize, float startAngleDegrees, float centerX, float centerY, float scaleFactorX, float scaleFactorY) {
        ClearCLBuffer temp = clij2.create(new long[]{result.getWidth(), result.getDepth(), result.getHeight()}, result.getNativeType());
        clij2.resliceRadial(input, temp, angleStepSize, startAngleDegrees, centerX, centerY, scaleFactorX, scaleFactorY);
        clij2.resliceTop((ClearCLImageInterface)temp, (ClearCLImageInterface)result);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number numberOfAngles, Number angleStepSize, Number startAngleDegrees, Number centerX, Number centerY, Number scaleFactorX, Number scaleFactorY";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        int numberOfAngles = ResliceRadialTop.asInteger((Object)this.args[2]);
        float angleStepSize = ResliceRadialTop.asFloat((Object)this.args[3]).floatValue();
        int effectiveNumberOfAngles = (int)((float)numberOfAngles / angleStepSize);
        int maximumRadius = (int)Math.sqrt(Math.pow(input.getWidth() / 2L, 2.0) + Math.pow(input.getHeight() / 2L, 2.0));
        return this.getCLIJ2().create(new long[]{maximumRadius, effectiveNumberOfAngles, input.getDepth()}, input.getNativeType());
    }

    public String getDescription() {
        return "Computes a radial projection of an image stack and reslices it from top. \n\nStarting point for the line is the given point in any \nX/Y-plane of a given input image stack. Furthermore, radius of the resulting projection must be given and scaling factors in X and Y in case pixels are not isotropic.This operation is similar to ImageJs 'Radial Reslice' method combined with 'Reslice from top' but offers less flexibility.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

