/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_resliceTop")
public class ResliceTop
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public boolean executeCL() {
        return this.getCLIJ2().resliceTop((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]));
    }

    public static boolean resliceTop(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", src);
        parameters.put("dst", dst);
        clij2.execute(ResliceTop.class, "reslice_top_3d_x.cl", "reslice_top_3d", dst.getDimensions(), dst.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.createCLBuffer(new long[]{input.getWidth(), input.getDepth(), input.getHeight()}, input.getNativeType());
    }

    public String getDescription() {
        return "Flippes Y and Z axis of an image stack. This operation is similar to ImageJs 'Reslice [/]' method but\noffers less flexibility such as interpolation.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }
}

