/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_saveAsTIF")
public class SaveAsTIF
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation {
    public Object[] getDefaultValues() {
        return new Object[]{null, "image.tif"};
    }

    public String getParameterHelpText() {
        return "Image input, String filename";
    }

    public boolean executeCL() {
        SaveAsTIF.saveAsTIF(this.getCLIJ2(), (ClearCLBuffer)this.args[0], this.args[1].toString());
        return true;
    }

    public static boolean saveAsTIF(CLIJ2 clij2, ClearCLBuffer input, String filename) {
        ImagePlus imp = clij2.pull(input);
        new File(filename).getParentFile().mkdirs();
        IJ.saveAsTiff((ImagePlus)imp, (String)filename);
        return new File(filename).exists();
    }

    public String getDescription() {
        return "Pulls an image from the GPU memory and saves it as TIF to disc.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

