/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.AffineTransform;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.realtransform.AffineTransform2D;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_scale2D")
public class Scale2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 1, 1, true};
    }

    public boolean executeCL() {
        float scaleFactorX = Scale2D.asFloat((Object)this.args[2]).floatValue();
        float scaleFactorY = Scale2D.asFloat((Object)this.args[3]).floatValue();
        boolean scaleAroundCenter = Scale2D.asBoolean((Object)this.args[4]);
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().scale2D(input, output, scaleFactorX, scaleFactorY, scaleAroundCenter);
    }

    public static boolean scale(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float factor) {
        return Scale2D.scale2D(clij2, input, output, factor, factor, false);
    }

    public static boolean scale(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float factorX, Float factorY) {
        return Scale2D.scale2D(clij2, input, output, factorX, factorY);
    }

    public static boolean scale2D(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float factorX, Float factorY) {
        return Scale2D.scale2D(clij2, input, output, factorX, factorY, false);
    }

    public static boolean scale2D(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float factorX, Float factorY, boolean scaleAroundCenter) {
        AffineTransform2D at = new AffineTransform2D();
        if (scaleAroundCenter) {
            at.translate(new double[]{-input.getWidth() / 2L, -input.getHeight() / 2L, -input.getDepth() / 2L});
        }
        at.scale(1.0 / (double)factorX.floatValue(), 1.0 / (double)factorY.floatValue());
        if (scaleAroundCenter) {
            at.translate(new double[]{input.getWidth() / 2L, input.getHeight() / 2L, input.getDepth() / 2L});
        }
        if (!clij2.hasImageSupport()) {
            return clij2.affineTransform2D(input, (ClearCLImageInterface)output, AffineTransform.matrixToFloatArray2D((AffineTransform2D)at));
        }
        ClearCLImage image = clij2.create(input.getDimensions(), ImageChannelDataType.Float);
        clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)image);
        clij2.affineTransform2D(image, (ClearCLImageInterface)output, AffineTransform.matrixToFloatArray2D((AffineTransform2D)at));
        clij2.release((ClearCLImageInterface)image);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number scaling_factor_x, Number scaling_factor_y, Boolean scale_to_center";
    }

    public String getDescription() {
        return "Scales an image with a given factor.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

