/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.Arrays;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_setPlane")
public class SetPlane
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Math";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, 0, 0};
    }

    public boolean executeCL() {
        return this.getCLIJ2().setPlane((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), SetPlane.asInteger((Object)this.args[1]).intValue(), SetPlane.asFloat((Object)this.args[2]).floatValue());
    }

    public static boolean setPlane(CLIJ2 clij2, ClearCLImageInterface clImage, Integer plane, Float value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("dst", clImage);
        parameters.put("value", value);
        parameters.put("plane", plane);
        long[] dimensions = Arrays.copyOf(clImage.getDimensions(), clImage.getDimensions().length);
        if (dimensions.length > 2) {
            dimensions[2] = 1L;
        }
        clij2.execute(SetPlane.class, "set_plane_" + clImage.getDimension() + "d_x.cl", "set_plane_" + clImage.getDimension() + "d", clImage.getDimensions(), dimensions, parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, Number plane_index, Number value";
    }

    public String getDescription() {
        return "Sets all pixel values x of a given plane in X to a constant value v.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

