/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import ij.gui.NewImage;
import java.util.Random;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_setRandom")
public class SetRandom
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Math";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, 0, 255, 0};
    }

    public boolean executeCL() {
        ClearCLBuffer buffer = (ClearCLBuffer)this.args[0];
        float minimumValue = SetRandom.asFloat((Object)this.args[1]).floatValue();
        float maximumValue = SetRandom.asFloat((Object)this.args[2]).floatValue();
        float seed = System.currentTimeMillis();
        if (this.args.length > 3) {
            seed = SetRandom.asFloat((Object)this.args[3]).floatValue();
        }
        this.getCLIJ2().setRandom(buffer, minimumValue, maximumValue, seed);
        return true;
    }

    public static boolean setRandom(CLIJ2 clij2, ClearCLBuffer target, Float minimumValue, Float maximumValue) {
        return SetRandom.setRandom(clij2, target, minimumValue, maximumValue, Float.valueOf(System.currentTimeMillis()));
    }

    public static boolean setRandom(CLIJ2 clij2, ClearCLBuffer target, Float minimumValue, Float maximumValue, Float seed) {
        ImagePlus imp = NewImage.createFloatImage((String)"", (int)((int)target.getWidth()), (int)((int)target.getHeight()), (int)((int)target.getDepth()), (int)1);
        Random random = new Random(seed.intValue());
        double range = maximumValue.floatValue() - minimumValue.floatValue();
        for (int z = 0; z < imp.getNSlices(); ++z) {
            imp.setZ(z + 1);
            float[] inputArray = (float[])imp.getProcessor().getPixels();
            for (int i = 0; i < inputArray.length; ++i) {
                inputArray[i] = (float)((double)random.nextFloat() * range + (double)minimumValue.floatValue());
            }
        }
        ClearCLBuffer buffer = clij2.push(imp);
        if (buffer.getDimension() != target.getDimension()) {
            clij2.copySlice((ClearCLImageInterface)buffer, (ClearCLImageInterface)target, 0.0);
        } else {
            clij2.copy((ClearCLImageInterface)buffer, (ClearCLImageInterface)target);
        }
        clij2.release((ClearCLImageInterface)buffer);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, Number minimumValue, Number maximumValue, Number seed";
    }

    public String getDescription() {
        return "Fills an image or image stack with uniformly distributed random numbers between given minimum and maximum values. \n\nRecommendation: For the seed, use getTime().";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

