/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.MinimumZProjectionThresholdedBounded;
import net.haesleinhuepf.clij2.plugins.TransposeYZ;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_shortestDistances")
public class ShortestDistances
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Matrix";
    }

    @Override
    public String getOutputType() {
        return "Vector";
    }

    public String getCategories() {
        return "Graph, Measurements";
    }

    public String getParameterHelpText() {
        return "Image distance_matrix, ByRef Image destination_minimum_distances";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().shortestDistances((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
        return result;
    }

    public static boolean shortestDistances(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output) {
        ClearCLBuffer temp = clij2.create(new long[]{input.getWidth(), 1L, input.getHeight()}, input.getNativeType());
        TransposeYZ.transposeYZ(clij2, input, temp);
        MinimumZProjectionThresholdedBounded.minimumZProjectionThresholdedBounded(clij2, temp, output, Float.valueOf(-1.0f), 1, (int)temp.getDepth());
        temp.close();
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(new long[]{input.getWidth(), 1L}, NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Determine the shortest distance from a distance matrix. \n\nThis corresponds to the minimum for each individial column.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

