/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_smaller")
public class Smaller
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public String getCategories() {
        return "Math";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().smaller((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2]);
        return result;
    }

    public static boolean smaller(CLIJ2 clij2, ClearCLBuffer src1, ClearCLBuffer src2, ClearCLBuffer dst) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.clear();
        parameters.put("src1", src1);
        parameters.put("src2", src2);
        parameters.put("dst", dst);
        clij2.execute(Smaller.class, "smaller_" + src1.getDimension() + "d_x.cl", "smaller_" + src1.getDimension() + "d", src1.getDimensions(), src1.getDimensions(), parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source1, Image source2, ByRef Image destination";
    }

    public String getDescription() {
        return "Determines if two images A and B smaller pixel wise.\n\nf(a, b) = 1 if a < b; 0 otherwise. ";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

