/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_squaredDifference")
public class SquaredDifference
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Math, Filter";
    }

    public boolean executeCL() {
        ClearCLBuffer buffer1 = (ClearCLBuffer)this.args[0];
        ClearCLBuffer buffer2 = (ClearCLBuffer)this.args[1];
        ClearCLBuffer result = (ClearCLBuffer)this.args[2];
        return SquaredDifference.squaredDifference(this.getCLIJ2(), buffer1, buffer2, result);
    }

    public static boolean squaredDifference(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer buffer2, ClearCLBuffer result) {
        ClearCLBuffer difference = clij2.create(buffer1.getDimensions(), NativeTypeEnum.Float);
        clij2.subtractImages((ClearCLImageInterface)buffer1, (ClearCLImageInterface)buffer2, (ClearCLImageInterface)difference);
        clij2.power((ClearCLImageInterface)difference, (ClearCLImageInterface)result, 2.0);
        difference.close();
        return true;
    }

    public String getParameterHelpText() {
        return "Image source1, Image source2, ByRef Image destination";
    }

    public String getDescription() {
        return "Determines the squared difference pixel by pixel between two images.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

