/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.MeanOfMaskedPixels;
import net.haesleinhuepf.clij2.plugins.VarianceOfMaskedPixels;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_standardDeviationOfMaskedPixels")
public class StandardDeviationOfMaskedPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Binary, Measurements";
    }

    public boolean executeCL() {
        double variance = 0.0;
        Object[] args = this.openCLBufferArgs();
        ClearCLBuffer buffer1 = (ClearCLBuffer)args[0];
        ClearCLBuffer mask = (ClearCLBuffer)args[1];
        variance = this.getCLIJ2().standardDeviationOfMaskedPixels(buffer1, mask);
        this.releaseBuffers(args);
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Masked_standard_deviation", variance);
        table.show("Results");
        return true;
    }

    public static double standardDeviationOfMaskedPixels(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer mask) {
        double meanIntensity = MeanOfMaskedPixels.meanOfMaskedPixels(clij2, buffer1, mask);
        return StandardDeviationOfMaskedPixels.standardDeviationOfMaskedPixels(clij2, buffer1, mask, new Float(meanIntensity));
    }

    public static double standardDeviationOfMaskedPixels(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer mask, Float meanIntensity) {
        return Math.sqrt(VarianceOfMaskedPixels.varianceOfMaskedPixels(clij2, buffer1, mask, meanIntensity));
    }

    public String getParameterHelpText() {
        return "Image source, Image mask";
    }

    public String getDescription() {
        return "Determines the standard deviation of all pixels in an image which have non-zero value in a corresponding mask image. \n\nThe value will be stored in a new row of ImageJs\nResults table in the column 'Masked_standard_deviation'.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

