/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.ImagePlus;
import ij.measure.ResultsTable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_statisticsOfLabelledPixels")
public class StatisticsOfLabelledPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurement";
    }

    public boolean executeCL() {
        ClearCLBuffer inputImage = (ClearCLBuffer)this.args[0];
        ClearCLBuffer inputLabelMap = (ClearCLBuffer)this.args[1];
        ResultsTable resultsTable = ResultsTable.getResultsTable();
        this.getCLIJ2().statisticsOfLabelledPixels(inputImage, inputLabelMap, resultsTable);
        resultsTable.show("Results");
        return true;
    }

    public static ResultsTable statisticsOfLabelledPixels(CLIJ2 clij2, ClearCLBuffer inputImage, ClearCLBuffer inputLabelMap, ResultsTable resultsTable) {
        double[][] statistics = StatisticsOfLabelledPixels.statisticsOfLabelledPixels(clij2, inputImage, inputLabelMap);
        return StatisticsOfLabelledPixels.statisticsArrayToResultsTable(statistics, resultsTable);
    }

    static ResultsTable statisticsArrayToResultsTable(double[][] statistics, ResultsTable resultsTable) {
        ArrayList<STATISTICS_ENTRY> entries = new ArrayList<STATISTICS_ENTRY>();
        entries.add(STATISTICS_ENTRY.IDENTIFIER);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_X);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_Y);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_Z);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_END_X);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_END_Y);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_END_Z);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_WIDTH);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_HEIGHT);
        entries.add(STATISTICS_ENTRY.BOUNDING_BOX_DEPTH);
        entries.add(STATISTICS_ENTRY.MINIMUM_INTENSITY);
        entries.add(STATISTICS_ENTRY.MAXIMUM_INTENSITY);
        entries.add(STATISTICS_ENTRY.MEAN_INTENSITY);
        entries.add(STATISTICS_ENTRY.SUM_INTENSITY);
        entries.add(STATISTICS_ENTRY.STANDARD_DEVIATION_INTENSITY);
        entries.add(STATISTICS_ENTRY.PIXEL_COUNT);
        entries.add(STATISTICS_ENTRY.SUM_INTENSITY_TIMES_X);
        entries.add(STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Y);
        entries.add(STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Z);
        entries.add(STATISTICS_ENTRY.MASS_CENTER_X);
        entries.add(STATISTICS_ENTRY.MASS_CENTER_Y);
        entries.add(STATISTICS_ENTRY.MASS_CENTER_Z);
        entries.add(STATISTICS_ENTRY.SUM_X);
        entries.add(STATISTICS_ENTRY.SUM_Y);
        entries.add(STATISTICS_ENTRY.SUM_Z);
        entries.add(STATISTICS_ENTRY.CENTROID_X);
        entries.add(STATISTICS_ENTRY.CENTROID_Y);
        entries.add(STATISTICS_ENTRY.CENTROID_Z);
        entries.add(STATISTICS_ENTRY.SUM_DISTANCE_TO_MASS_CENTER);
        entries.add(STATISTICS_ENTRY.MEAN_DISTANCE_TO_MASS_CENTER);
        entries.add(STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER);
        entries.add(STATISTICS_ENTRY.MAX_MEAN_DISTANCE_TO_MASS_CENTER_RATIO);
        entries.add(STATISTICS_ENTRY.SUM_DISTANCE_TO_CENTROID);
        entries.add(STATISTICS_ENTRY.MEAN_DISTANCE_TO_CENTROID);
        entries.add(STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID);
        entries.add(STATISTICS_ENTRY.MAX_MEAN_DISTANCE_TO_CENTROID_RATIO);
        for (int line = 0; line < statistics.length; ++line) {
            resultsTable.incrementCounter();
            for (STATISTICS_ENTRY entry : entries) {
                resultsTable.addValue(entry.toString(), statistics[line][entry.value]);
            }
        }
        return resultsTable;
    }

    public static double[][] statisticsOfLabelledPixels(CLIJ2 clij2, ClearCLBuffer inputImage, ClearCLBuffer inputLabelMap) {
        int numberOfLabels = (int)clij2.maximumOfAllPixels((ClearCLImageInterface)inputLabelMap);
        return StatisticsOfLabelledPixels.statisticsOfLabelledPixels(clij2, inputImage, inputLabelMap, 1, numberOfLabels);
    }

    public static double[] statisticsOfLabelledPixels(CLIJ2 clij2, ClearCLBuffer inputImage, ClearCLBuffer inputLabelMap, Integer labelIndex) {
        return StatisticsOfLabelledPixels.statisticsOfLabelledPixels(clij2, inputImage, inputLabelMap, labelIndex, labelIndex)[0];
    }

    public static double[][] statisticsOfLabelledPixels(CLIJ2 clij2, ClearCLBuffer inputImage, ClearCLBuffer inputLabelMap, Integer startLabelIndex, Integer endLabelIndex) {
        int t;
        int t2;
        int i;
        int num_threads = (int)inputImage.getDepth();
        STATISTICS_ENTRY[] indices_to_min_collect = new STATISTICS_ENTRY[]{STATISTICS_ENTRY.BOUNDING_BOX_X, STATISTICS_ENTRY.BOUNDING_BOX_Y, STATISTICS_ENTRY.BOUNDING_BOX_Z, STATISTICS_ENTRY.MINIMUM_INTENSITY};
        STATISTICS_ENTRY[] indices_to_max_collect = new STATISTICS_ENTRY[]{STATISTICS_ENTRY.BOUNDING_BOX_END_X, STATISTICS_ENTRY.BOUNDING_BOX_END_Y, STATISTICS_ENTRY.BOUNDING_BOX_END_Z, STATISTICS_ENTRY.MAXIMUM_INTENSITY};
        STATISTICS_ENTRY[] indices_to_sum_collect = new STATISTICS_ENTRY[]{STATISTICS_ENTRY.SUM_INTENSITY, STATISTICS_ENTRY.PIXEL_COUNT, STATISTICS_ENTRY.SUM_INTENSITY_TIMES_X, STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Y, STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Z, STATISTICS_ENTRY.SUM_X, STATISTICS_ENTRY.SUM_Y, STATISTICS_ENTRY.SUM_Z};
        double[][][] statistics = new double[num_threads + 1][endLabelIndex - startLabelIndex + 1][36];
        for (int t3 = 0; t3 < num_threads; ++t3) {
            for (int j = 0; j < statistics[0].length; ++j) {
                for (STATISTICS_ENTRY entry : indices_to_max_collect) {
                    statistics[t3 + 1][j][entry.value] = -1.7976931348623157E308;
                }
                for (STATISTICS_ENTRY entry : indices_to_min_collect) {
                    statistics[t3 + 1][j][entry.value] = Double.MAX_VALUE;
                }
            }
        }
        Thread[] threads = new Thread[num_threads];
        Statistician[] statisticians = new Statistician[num_threads];
        for (i = 0; i < num_threads; ++i) {
            statisticians[i] = new Statistician(statistics[i + 1], clij2, inputImage, inputLabelMap, startLabelIndex, endLabelIndex, i);
            threads[i] = new Thread(statisticians[i]);
            threads[i].start();
        }
        for (i = 0; i < num_threads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (t2 = 0; t2 < num_threads; ++t2) {
            for (int j = 0; j < statistics[0].length; ++j) {
                for (STATISTICS_ENTRY entry : indices_to_max_collect) {
                    statistics[0][j][entry.value] = t2 == 0 ? statistics[t2 + 1][j][entry.value] : Math.max(statistics[0][j][entry.value], statistics[t2 + 1][j][entry.value]);
                }
                for (STATISTICS_ENTRY entry : indices_to_min_collect) {
                    statistics[0][j][entry.value] = t2 == 0 ? statistics[t2 + 1][j][entry.value] : Math.min(statistics[0][j][entry.value], statistics[t2 + 1][j][entry.value]);
                }
                for (STATISTICS_ENTRY entry : indices_to_sum_collect) {
                    double[] dArray = statistics[0][j];
                    int n = entry.value;
                    dArray[n] = dArray[n] + statistics[t2 + 1][j][entry.value];
                }
            }
        }
        for (int j = 0; j < statistics[0].length; ++j) {
            statistics[0][j][STATISTICS_ENTRY.MEAN_INTENSITY.value] = statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY.value] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_WIDTH.value] = statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_END_X.value] - statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_X.value] + 1.0;
            statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_HEIGHT.value] = statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_END_Y.value] - statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_Y.value] + 1.0;
            statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_DEPTH.value] = statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_END_Z.value] - statistics[0][j][STATISTICS_ENTRY.BOUNDING_BOX_Z.value] + 1.0;
            statistics[0][j][STATISTICS_ENTRY.IDENTIFIER.value] = j + startLabelIndex;
            statistics[0][j][STATISTICS_ENTRY.MASS_CENTER_X.value] = statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY_TIMES_X.value] / statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY.value];
            statistics[0][j][STATISTICS_ENTRY.MASS_CENTER_Y.value] = statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Y.value] / statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY.value];
            statistics[0][j][STATISTICS_ENTRY.MASS_CENTER_Z.value] = statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Z.value] / statistics[0][j][STATISTICS_ENTRY.SUM_INTENSITY.value];
            statistics[0][j][STATISTICS_ENTRY.CENTROID_X.value] = statistics[0][j][STATISTICS_ENTRY.SUM_X.value] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[0][j][STATISTICS_ENTRY.CENTROID_Y.value] = statistics[0][j][STATISTICS_ENTRY.SUM_Y.value] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[0][j][STATISTICS_ENTRY.CENTROID_Z.value] = statistics[0][j][STATISTICS_ENTRY.SUM_Z.value] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value];
        }
        for (t2 = 0; t2 < num_threads; ++t2) {
            for (int j = 0; j < statistics[0].length; ++j) {
                statistics[t2 + 1][j][STATISTICS_ENTRY.MEAN_INTENSITY.value] = statistics[0][j][STATISTICS_ENTRY.MEAN_INTENSITY.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.MASS_CENTER_X.value] = statistics[0][j][STATISTICS_ENTRY.MASS_CENTER_X.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.MASS_CENTER_Y.value] = statistics[0][j][STATISTICS_ENTRY.MASS_CENTER_Y.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.MASS_CENTER_Z.value] = statistics[0][j][STATISTICS_ENTRY.MASS_CENTER_Z.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.CENTROID_X.value] = statistics[0][j][STATISTICS_ENTRY.CENTROID_X.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.CENTROID_Y.value] = statistics[0][j][STATISTICS_ENTRY.CENTROID_Y.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.CENTROID_Z.value] = statistics[0][j][STATISTICS_ENTRY.CENTROID_Z.value];
                statistics[t2 + 1][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value] = 0.0;
                statistics[t2 + 1][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value] = 0.0;
                if (t2 != 0) continue;
                statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value] = 0.0;
                statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value] = 0.0;
            }
        }
        double[][] squaredDifferencesFromMean = new double[num_threads + 1][statistics[0].length];
        Thread[] followUpThreads = new Thread[num_threads];
        for (t = 0; t < num_threads; ++t) {
            followUpThreads[t] = new Thread(new SecondOrderStatistician(statisticians[t].pixels, statisticians[t].labels, startLabelIndex, (int)inputImage.getWidth(), t, statistics[t + 1], squaredDifferencesFromMean[t + 1]));
            followUpThreads[t].start();
        }
        for (t = 0; t < num_threads; ++t) {
            try {
                followUpThreads[t].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (t = 0; t < num_threads; ++t) {
            for (int j = 0; j < statistics[0].length; ++j) {
                double[] dArray = squaredDifferencesFromMean[0];
                int n = j;
                dArray[n] = dArray[n] + squaredDifferencesFromMean[t + 1][j];
                statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value] = Math.max(statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value], statistics[t + 1][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value]);
                statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value] = Math.max(statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value], statistics[t + 1][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value]);
                statistics[0][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_MASS_CENTER.value] = statistics[0][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_MASS_CENTER.value] + statistics[t + 1][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_MASS_CENTER.value];
                statistics[0][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_CENTROID.value] = statistics[0][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_CENTROID.value] + statistics[t + 1][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_CENTROID.value];
            }
        }
        for (int j = 0; j < statistics[0].length; ++j) {
            statistics[0][j][STATISTICS_ENTRY.STANDARD_DEVIATION_INTENSITY.value] = Math.sqrt(squaredDifferencesFromMean[0][j] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value]);
            statistics[0][j][STATISTICS_ENTRY.MEAN_DISTANCE_TO_MASS_CENTER.value] = statistics[0][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_MASS_CENTER.value] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[0][j][STATISTICS_ENTRY.MEAN_DISTANCE_TO_CENTROID.value] = statistics[0][j][STATISTICS_ENTRY.SUM_DISTANCE_TO_CENTROID.value] / statistics[0][j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[0][j][STATISTICS_ENTRY.MAX_MEAN_DISTANCE_TO_MASS_CENTER_RATIO.value] = statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value] / statistics[0][j][STATISTICS_ENTRY.MEAN_DISTANCE_TO_MASS_CENTER.value];
            statistics[0][j][STATISTICS_ENTRY.MAX_MEAN_DISTANCE_TO_CENTROID_RATIO.value] = statistics[0][j][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value] / statistics[0][j][STATISTICS_ENTRY.MEAN_DISTANCE_TO_CENTROID.value];
        }
        return statistics[0];
    }

    public static double[][] statisticsOfLabelledPixels_single_threaded(CLIJ2 clij2, ClearCLBuffer inputImage, ClearCLBuffer inputLabelMap, Integer startLabelIndex, Integer endLabelIndex) {
        double[][] statistics = new double[endLabelIndex - startLabelIndex + 1][36];
        boolean[] initializedFlags = new boolean[statistics.length];
        ClearCLBuffer image = inputImage;
        ClearCLBuffer labelMap = inputLabelMap;
        if (inputImage.getNativeType() != NativeTypeEnum.Float) {
            image = clij2.create(inputImage.getDimensions(), NativeTypeEnum.Float);
            clij2.copy((ClearCLImageInterface)inputImage, (ClearCLImageInterface)image);
        }
        if (inputLabelMap != null && inputLabelMap.getNativeType() != NativeTypeEnum.Float) {
            labelMap = clij2.create(inputLabelMap.getDimensions(), NativeTypeEnum.Float);
            clij2.copy((ClearCLImageInterface)inputLabelMap, (ClearCLImageInterface)labelMap);
        }
        ImagePlus imp = clij2.pull(image);
        ImagePlus lab = inputLabelMap != null ? clij2.pull(labelMap) : null;
        int width = imp.getWidth();
        for (int z = 0; z < imp.getNSlices(); ++z) {
            imp.setZ(z + 1);
            if (lab != null) {
                lab.setZ(z + 1);
            }
            float[] pixels = (float[])imp.getProcessor().getPixels();
            float[] labels = lab != null ? (float[])lab.getProcessor().getPixels() : null;
            int x = 0;
            int y = 0;
            for (int i = 0; i < pixels.length; ++i) {
                int index;
                int n = index = labels != null ? (int)labels[i] : 0;
                if (index >= startLabelIndex) {
                    int targetIndex = index - startLabelIndex;
                    double value = pixels[i];
                    boolean initialized = initializedFlags[targetIndex];
                    if ((double)x < statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_X.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_X.value] = x;
                    }
                    if ((double)y < statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Y.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Y.value] = y;
                    }
                    if ((double)z < statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Z.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Z.value] = z;
                    }
                    if ((double)x > statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_X.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_X.value] = x;
                    }
                    if ((double)y > statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Y.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Y.value] = y;
                    }
                    if ((double)z > statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Z.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Z.value] = z;
                    }
                    if (value > statistics[targetIndex][STATISTICS_ENTRY.MAXIMUM_INTENSITY.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.MAXIMUM_INTENSITY.value] = value;
                    }
                    if (value < statistics[targetIndex][STATISTICS_ENTRY.MINIMUM_INTENSITY.value] || !initialized) {
                        statistics[targetIndex][STATISTICS_ENTRY.MINIMUM_INTENSITY.value] = value;
                    }
                    double[] dArray = statistics[targetIndex];
                    int n2 = STATISTICS_ENTRY.SUM_INTENSITY.value;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = statistics[targetIndex];
                    int n3 = STATISTICS_ENTRY.SUM_INTENSITY_TIMES_X.value;
                    dArray2[n3] = dArray2[n3] + value * (double)x;
                    double[] dArray3 = statistics[targetIndex];
                    int n4 = STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Y.value;
                    dArray3[n4] = dArray3[n4] + value * (double)y;
                    double[] dArray4 = statistics[targetIndex];
                    int n5 = STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Z.value;
                    dArray4[n5] = dArray4[n5] + value * (double)z;
                    double[] dArray5 = statistics[targetIndex];
                    int n6 = STATISTICS_ENTRY.SUM_X.value;
                    dArray5[n6] = dArray5[n6] + (double)x;
                    double[] dArray6 = statistics[targetIndex];
                    int n7 = STATISTICS_ENTRY.SUM_Y.value;
                    dArray6[n7] = dArray6[n7] + (double)y;
                    double[] dArray7 = statistics[targetIndex];
                    int n8 = STATISTICS_ENTRY.SUM_Z.value;
                    dArray7[n8] = dArray7[n8] + (double)z;
                    double[] dArray8 = statistics[targetIndex];
                    int n9 = STATISTICS_ENTRY.PIXEL_COUNT.value;
                    dArray8[n9] = dArray8[n9] + 1.0;
                    initializedFlags[targetIndex] = true;
                }
                if (++x < width) continue;
                x = 0;
                ++y;
            }
        }
        for (int j = 0; j < statistics.length; ++j) {
            statistics[j][STATISTICS_ENTRY.MEAN_INTENSITY.value] = statistics[j][STATISTICS_ENTRY.SUM_INTENSITY.value] / statistics[j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_WIDTH.value] = statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_END_X.value] - statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_X.value] + 1.0;
            statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_HEIGHT.value] = statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_END_Y.value] - statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_Y.value] + 1.0;
            statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_DEPTH.value] = statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_END_Z.value] - statistics[j][STATISTICS_ENTRY.BOUNDING_BOX_Z.value] + 1.0;
            statistics[j][STATISTICS_ENTRY.IDENTIFIER.value] = j + startLabelIndex;
            statistics[j][STATISTICS_ENTRY.MASS_CENTER_X.value] = statistics[j][STATISTICS_ENTRY.SUM_INTENSITY_TIMES_X.value] / statistics[j][STATISTICS_ENTRY.SUM_INTENSITY.value];
            statistics[j][STATISTICS_ENTRY.MASS_CENTER_Y.value] = statistics[j][STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Y.value] / statistics[j][STATISTICS_ENTRY.SUM_INTENSITY.value];
            statistics[j][STATISTICS_ENTRY.MASS_CENTER_Z.value] = statistics[j][STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Z.value] / statistics[j][STATISTICS_ENTRY.SUM_INTENSITY.value];
            statistics[j][STATISTICS_ENTRY.CENTROID_X.value] = statistics[j][STATISTICS_ENTRY.SUM_X.value] / statistics[j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[j][STATISTICS_ENTRY.CENTROID_Y.value] = statistics[j][STATISTICS_ENTRY.SUM_Y.value] / statistics[j][STATISTICS_ENTRY.PIXEL_COUNT.value];
            statistics[j][STATISTICS_ENTRY.CENTROID_Z.value] = statistics[j][STATISTICS_ENTRY.SUM_Z.value] / statistics[j][STATISTICS_ENTRY.PIXEL_COUNT.value];
        }
        double[] squaredDifferencesFromMean = new double[statistics.length];
        for (int z = 0; z < imp.getNSlices(); ++z) {
            imp.setZ(z + 1);
            if (lab != null) {
                lab.setZ(z + 1);
            }
            float[] pixels = (float[])imp.getProcessor().getPixels();
            float[] labels = lab != null ? (float[])lab.getProcessor().getPixels() : null;
            for (int i = 0; i < pixels.length; ++i) {
                int index;
                int n = index = labels != null ? (int)labels[i] : 0;
                if (index < startLabelIndex) continue;
                int targetIndex = index - startLabelIndex;
                double value = pixels[i];
                int n10 = targetIndex;
                squaredDifferencesFromMean[n10] = squaredDifferencesFromMean[n10] + Math.pow(value - statistics[targetIndex][STATISTICS_ENTRY.MEAN_INTENSITY.value], 2.0);
            }
        }
        for (int j = 0; j < statistics.length; ++j) {
            statistics[j][STATISTICS_ENTRY.STANDARD_DEVIATION_INTENSITY.value] = Math.sqrt(squaredDifferencesFromMean[j] / statistics[j][STATISTICS_ENTRY.PIXEL_COUNT.value]);
        }
        if (inputImage != image) {
            image.close();
        }
        if (inputLabelMap != labelMap && labelMap != null) {
            labelMap.close();
        }
        return statistics;
    }

    public String getParameterHelpText() {
        return "Image input, Image labelmap";
    }

    public String getDescription() {
        return "Determines bounding box, area (in pixels/voxels), min, max and mean intensity \n of labelled objects in a label map and corresponding pixels in the original image. \n\nInstead of a label map, you can also use a binary image as a binary image is a label map with just one label.\n\nThis method is executed on the CPU and not on the GPU/OpenCL device.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    private static class SecondOrderStatistician
    implements Runnable {
        private final float[] pixels;
        private final float[] labels;
        private final int startLabelIndex;
        private final double[][] statistics;
        private final double[] squaredDifferencesFromMean;
        private final int width;
        private final int z;

        SecondOrderStatistician(float[] pixels, float[] labels, int startLabelIndex, int width, int z, double[][] statistics, double[] squaredDifferencesFromMean) {
            this.pixels = pixels;
            this.labels = labels;
            this.startLabelIndex = startLabelIndex;
            this.statistics = statistics;
            this.squaredDifferencesFromMean = squaredDifferencesFromMean;
            this.width = width;
            this.z = z;
        }

        @Override
        public void run() {
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.pixels.length; ++i) {
                int index;
                int n = index = this.labels != null ? (int)this.labels[i] : 0;
                if (index >= this.startLabelIndex) {
                    int targetIndex = index - this.startLabelIndex;
                    double value = this.pixels[i];
                    int n2 = targetIndex;
                    this.squaredDifferencesFromMean[n2] = this.squaredDifferencesFromMean[n2] + Math.pow(value - this.statistics[targetIndex][STATISTICS_ENTRY.MEAN_INTENSITY.value], 2.0);
                    double mass_center_x = this.statistics[targetIndex][STATISTICS_ENTRY.MASS_CENTER_X.value];
                    double mass_center_y = this.statistics[targetIndex][STATISTICS_ENTRY.MASS_CENTER_Y.value];
                    double mass_center_z = this.statistics[targetIndex][STATISTICS_ENTRY.MASS_CENTER_Z.value];
                    double distance = Math.sqrt(Math.pow(mass_center_x - (double)x, 2.0) + Math.pow(mass_center_y - (double)y, 2.0) + Math.pow(mass_center_z - (double)this.z, 2.0));
                    if (this.statistics[targetIndex][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value] < distance) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.MAX_DISTANCE_TO_MASS_CENTER.value] = distance;
                    }
                    double[] dArray = this.statistics[targetIndex];
                    int n3 = STATISTICS_ENTRY.SUM_DISTANCE_TO_MASS_CENTER.value;
                    dArray[n3] = dArray[n3] + distance;
                    double center_x = this.statistics[targetIndex][STATISTICS_ENTRY.CENTROID_X.value];
                    double center_y = this.statistics[targetIndex][STATISTICS_ENTRY.CENTROID_Y.value];
                    double center_z = this.statistics[targetIndex][STATISTICS_ENTRY.CENTROID_Z.value];
                    distance = Math.sqrt(Math.pow(center_x - (double)x, 2.0) + Math.pow(center_y - (double)y, 2.0) + Math.pow(center_z - (double)this.z, 2.0));
                    if (this.statistics[targetIndex][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value] < distance) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.MAX_DISTANCE_TO_CENTROID.value] = distance;
                    }
                    double[] dArray2 = this.statistics[targetIndex];
                    int n4 = STATISTICS_ENTRY.SUM_DISTANCE_TO_CENTROID.value;
                    dArray2[n4] = dArray2[n4] + distance;
                }
                if (++x < this.width) continue;
                x = 0;
                ++y;
            }
        }
    }

    private static class Statistician
    implements Runnable {
        private double[][] statistics;
        private final ClearCLBuffer inputImage;
        private final ClearCLBuffer inputLabelMap;
        private final int startLabelIndex;
        private final int endLabelIndex;
        private final int zPlane;
        private final CLIJ2 clij2;
        float[] pixels;
        float[] labels;

        Statistician(double[][] statistics, CLIJ2 clij2, ClearCLBuffer inputImage, ClearCLBuffer inputLabelMap, int startLabelIndex, int endLabelIndex, int zPlane) {
            this.statistics = statistics;
            this.inputImage = inputImage;
            this.inputLabelMap = inputLabelMap;
            this.startLabelIndex = startLabelIndex;
            this.endLabelIndex = endLabelIndex;
            this.zPlane = zPlane;
            this.clij2 = clij2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean[] initializedFlags = new boolean[this.statistics.length];
            CLIJ2 cLIJ2 = this.clij2;
            synchronized (cLIJ2) {
                ClearCLBuffer image = this.clij2.create(this.inputImage.getWidth(), this.inputImage.getHeight());
                this.clij2.copySlice((ClearCLImageInterface)this.inputImage, (ClearCLImageInterface)image, this.zPlane);
                ClearCLBuffer labelMap = null;
                if (this.inputLabelMap != null) {
                    labelMap = this.clij2.create(this.inputLabelMap.getWidth(), this.inputLabelMap.getHeight());
                    this.clij2.copySlice((ClearCLImageInterface)this.inputLabelMap, (ClearCLImageInterface)labelMap, this.zPlane);
                }
                this.pixels = new float[(int)(image.getWidth() * image.getHeight())];
                image.writeTo((Buffer)FloatBuffer.wrap(this.pixels), true);
                image.close();
                if (labelMap != null) {
                    this.labels = new float[(int)(labelMap.getWidth() * labelMap.getHeight())];
                    labelMap.writeTo((Buffer)FloatBuffer.wrap(this.labels), true);
                    labelMap.close();
                }
            }
            int width = (int)this.inputImage.getWidth();
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.pixels.length; ++i) {
                int index;
                int n = index = this.labels != null ? (int)this.labels[i] : 0;
                if (index >= this.startLabelIndex) {
                    int targetIndex = index - this.startLabelIndex;
                    double value = this.pixels[i];
                    boolean initialized = initializedFlags[targetIndex];
                    if ((double)x < this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_X.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_X.value] = x;
                    }
                    if ((double)y < this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Y.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Y.value] = y;
                    }
                    if ((double)this.zPlane < this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Z.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_Z.value] = this.zPlane;
                    }
                    if ((double)x > this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_X.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_X.value] = x;
                    }
                    if ((double)y > this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Y.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Y.value] = y;
                    }
                    if ((double)this.zPlane > this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Z.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.BOUNDING_BOX_END_Z.value] = this.zPlane;
                    }
                    if (value > this.statistics[targetIndex][STATISTICS_ENTRY.MAXIMUM_INTENSITY.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.MAXIMUM_INTENSITY.value] = value;
                    }
                    if (value < this.statistics[targetIndex][STATISTICS_ENTRY.MINIMUM_INTENSITY.value] || !initialized) {
                        this.statistics[targetIndex][STATISTICS_ENTRY.MINIMUM_INTENSITY.value] = value;
                    }
                    double[] dArray = this.statistics[targetIndex];
                    int n2 = STATISTICS_ENTRY.SUM_INTENSITY.value;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = this.statistics[targetIndex];
                    int n3 = STATISTICS_ENTRY.SUM_INTENSITY_TIMES_X.value;
                    dArray2[n3] = dArray2[n3] + value * (double)x;
                    double[] dArray3 = this.statistics[targetIndex];
                    int n4 = STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Y.value;
                    dArray3[n4] = dArray3[n4] + value * (double)y;
                    double[] dArray4 = this.statistics[targetIndex];
                    int n5 = STATISTICS_ENTRY.SUM_INTENSITY_TIMES_Z.value;
                    dArray4[n5] = dArray4[n5] + value * (double)this.zPlane;
                    double[] dArray5 = this.statistics[targetIndex];
                    int n6 = STATISTICS_ENTRY.SUM_X.value;
                    dArray5[n6] = dArray5[n6] + (double)x;
                    double[] dArray6 = this.statistics[targetIndex];
                    int n7 = STATISTICS_ENTRY.SUM_Y.value;
                    dArray6[n7] = dArray6[n7] + (double)y;
                    double[] dArray7 = this.statistics[targetIndex];
                    int n8 = STATISTICS_ENTRY.SUM_Z.value;
                    dArray7[n8] = dArray7[n8] + (double)this.zPlane;
                    double[] dArray8 = this.statistics[targetIndex];
                    int n9 = STATISTICS_ENTRY.PIXEL_COUNT.value;
                    dArray8[n9] = dArray8[n9] + 1.0;
                    initializedFlags[targetIndex] = true;
                }
                if (++x < width) continue;
                x = 0;
                ++y;
            }
        }
    }

    public static enum STATISTICS_ENTRY {
        IDENTIFIER(0),
        BOUNDING_BOX_X(1),
        BOUNDING_BOX_Y(2),
        BOUNDING_BOX_Z(3),
        BOUNDING_BOX_END_X(4),
        BOUNDING_BOX_END_Y(5),
        BOUNDING_BOX_END_Z(6),
        BOUNDING_BOX_WIDTH(7),
        BOUNDING_BOX_HEIGHT(8),
        BOUNDING_BOX_DEPTH(9),
        MINIMUM_INTENSITY(10),
        MAXIMUM_INTENSITY(11),
        MEAN_INTENSITY(12),
        SUM_INTENSITY(13),
        STANDARD_DEVIATION_INTENSITY(14),
        PIXEL_COUNT(15),
        SUM_INTENSITY_TIMES_X(16),
        SUM_INTENSITY_TIMES_Y(17),
        SUM_INTENSITY_TIMES_Z(18),
        MASS_CENTER_X(19),
        MASS_CENTER_Y(20),
        MASS_CENTER_Z(21),
        SUM_X(22),
        SUM_Y(23),
        SUM_Z(24),
        CENTROID_X(25),
        CENTROID_Y(26),
        CENTROID_Z(27),
        SUM_DISTANCE_TO_MASS_CENTER(28),
        MEAN_DISTANCE_TO_MASS_CENTER(29),
        MAX_DISTANCE_TO_MASS_CENTER(30),
        MAX_MEAN_DISTANCE_TO_MASS_CENTER_RATIO(31),
        SUM_DISTANCE_TO_CENTROID(32),
        MEAN_DISTANCE_TO_CENTROID(33),
        MAX_DISTANCE_TO_CENTROID(34),
        MAX_MEAN_DISTANCE_TO_CENTROID_RATIO(35);

        static final int NUMBER_OF_ENTRIES = 36;
        public final int value;

        private STATISTICS_ENTRY(int value) {
            this.value = value;
        }
    }
}

