/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.CLIJUtilities;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_sumImageSliceBySlice")
public class SumImageSliceBySlice
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Vector";
    }

    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        return this.getCLIJ2().sumImageSliceBySlice((ClearCLImageInterface)((ClearCLBuffer)this.args[0]), (ClearCLImageInterface)((ClearCLBuffer)this.args[1]));
    }

    @Deprecated
    public static double[] sumPixelsSliceByslice(CLIJ2 clij2, ClearCLImageInterface src) {
        return SumImageSliceBySlice.sumImageSliceBySlice(clij2, src);
    }

    public static double[] sumImageSliceBySlice(CLIJ2 clij2, ClearCLImageInterface src) {
        ClearCLBuffer intensities = clij2.create(new long[]{src.getDepth(), 1L, 1L}, NativeTypeEnum.Float);
        SumImageSliceBySlice.sumImageSliceBySlice(clij2, src, (ClearCLImageInterface)intensities);
        float[] array = new float[(int)intensities.getWidth()];
        FloatBuffer fBuffer = FloatBuffer.wrap(array);
        intensities.writeTo((Buffer)fBuffer, true);
        clij2.release((ClearCLImageInterface)intensities);
        double[] result = new double[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean sumImageSliceBySlice(CLIJ2 clij2, ClearCLImageInterface src, ClearCLImageInterface dst) {
        CLIJUtilities.assertDifferent((Object)src, (Object)dst);
        ClearCLBuffer temp1 = clij2.create(new long[]{src.getDepth(), src.getHeight()});
        clij2.sumXProjection(src, (ClearCLImageInterface)temp1);
        clij2.sumYProjection((ClearCLImageInterface)temp1, dst);
        clij2.release((ClearCLImageInterface)temp1);
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDepth(), 1L, 1L);
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination";
    }

    public String getDescription() {
        return "Sums all pixels slice by slice and returns the sums in a vector.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

