/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_sumOfAllPixels")
public class SumOfAllPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Measurements";
    }

    public boolean executeCL() {
        double sum = this.getCLIJ2().sumOfAllPixels((ClearCLImageInterface)((ClearCLBuffer)this.args[0]));
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Sum", sum);
        table.show("Results");
        return true;
    }

    @Deprecated
    public static double sumPixels(CLIJ2 clij2, ClearCLImageInterface clImage) {
        return SumOfAllPixels.sumOfAllPixels(clij2, clImage);
    }

    public static double sumOfAllPixels(CLIJ2 clij2, ClearCLImageInterface clImage) {
        ClearCLImageInterface clReducedImage = clImage;
        if (clImage.getDimension() == 3L) {
            clReducedImage = clij2.create(new long[]{clImage.getWidth(), clImage.getHeight()}, ImageChannelDataType.Float);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("src", clImage);
            parameters.put("dst", clReducedImage);
            clij2.execute(SumOfAllPixels.class, "sum_z_projection_x.cl", "sum_z_projection", clReducedImage.getDimensions(), clReducedImage.getDimensions(), parameters);
        }
        ClearCLBuffer temp = clij2.create(1L, clReducedImage.getHeight());
        clij2.sumXProjection(clReducedImage, (ClearCLImageInterface)temp);
        RandomAccessibleInterval rai = clij2.convert(temp, RandomAccessibleInterval.class);
        temp.close();
        Cursor cursor = Views.iterable((RandomAccessibleInterval)rai).cursor();
        float sum = 0.0f;
        while (cursor.hasNext()) {
            sum += ((RealType)cursor.next()).getRealFloat();
        }
        if (clImage != clReducedImage) {
            clij2.release(clReducedImage);
        }
        return sum;
    }

    public String getParameterHelpText() {
        return "Image source";
    }

    public String getDescription() {
        return "Determines the sum of all pixels in a given image. \n\nIt will be stored in a new row of ImageJs\nResults table in the column 'Sum'.\n\nParameters\n----------\nsource : Image\n    The image of which all pixels or voxels will be summed.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

