/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasAuthor;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.HasLicense;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_thresholdMean")
public class ThresholdMean
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
HasAuthor,
HasLicense,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public String getCategories() {
        return "Binary, Segmentation";
    }

    public boolean executeCL() {
        ClearCLBuffer src = (ClearCLBuffer)this.args[0];
        ClearCLBuffer dst = (ClearCLBuffer)this.args[1];
        return ThresholdMean.thresholdMean(this.getCLIJ2(), src, dst);
    }

    public static boolean thresholdMean(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst) {
        return clij2.automaticThreshold(src, dst, "Mean");
    }

    public String getDescription() {
        StringBuilder doc = new StringBuilder();
        doc.append("The automatic thresholder utilizes the Mean threshold method implemented in ImageJ using a histogram determined on \nthe GPU to create binary images as similar as possible to ImageJ 'Apply Threshold' method.");
        return doc.toString();
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getAuthorName() {
        return "Robert Haase based on work by G. Landini and W. Rasband";
    }

    public String getLicense() {
        return "The code for the automatic thresholding methods originates from https://github.com/imagej/imagej1/blob/master/ij/process/AutoThresholder.java\n\nDetailed documentation on the implemented methods can be found online: https://imagej.net/Auto_Threshold";
    }
}

