/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clij2.utilities.ProcessableInTiles;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_topHatBox")
public class TopHatBox
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
ProcessableInTiles,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Background, Filter";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 10, 10, 10};
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number radiusX, Number radiusY, Number radiusZ";
    }

    public boolean executeCL() {
        boolean result = this.getCLIJ2().topHatBox((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], TopHatBox.asInteger((Object)this.args[2]).intValue(), TopHatBox.asInteger((Object)this.args[3]).intValue(), TopHatBox.asInteger((Object)this.args[4]).intValue());
        return result;
    }

    public static boolean topHatBox(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Integer radiusX, Integer radiusY, Integer radiusZ) {
        ClearCLBuffer temp1 = clij2.create(input);
        ClearCLBuffer temp2 = clij2.create(input);
        if (input.getDimension() == 3L) {
            clij2.minimum3DBox((ClearCLImageInterface)input, (ClearCLImageInterface)temp1, radiusX.intValue(), radiusX.intValue(), radiusZ.intValue());
            clij2.maximum3DBox((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2, radiusX.intValue(), radiusY.intValue(), radiusZ.intValue());
        } else {
            clij2.minimum2DBox((ClearCLImageInterface)input, (ClearCLImageInterface)temp1, radiusX.intValue(), radiusX.intValue());
            clij2.maximum2DBox((ClearCLImageInterface)temp1, (ClearCLImageInterface)temp2, radiusX.intValue(), radiusY.intValue());
        }
        clij2.subtractImages((ClearCLImageInterface)input, (ClearCLImageInterface)temp2, (ClearCLImageInterface)output);
        clij2.release((ClearCLImageInterface)temp1);
        clij2.release((ClearCLImageInterface)temp2);
        return true;
    }

    public String getDescription() {
        return "Applies a top-hat filter for background subtraction to the input image.\n\nParameters\n----------\ninput : Image\n    The input image where the background is subtracted from.\ndestination : Image\n    The output image where results are written into.\nradius_x : Image\n    Radius of the background determination region in X.\nradius_y : Image\n    Radius of the background determination region in Y.\nradius_z : Image\n    Radius of the background determination region in Z.\n";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

