/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_touchMatrixToAdjacencyMatrix")
public class TouchMatrixToAdjacencyMatrix
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Matrix";
    }

    @Override
    public String getOutputType() {
        return "Matrix";
    }

    public String getCategories() {
        return "Graph, Transform";
    }

    public String getParameterHelpText() {
        return "Image touch_matrix, ByRef Image adjacency_matrix";
    }

    public boolean executeCL() {
        ClearCLBuffer touch_matrix = (ClearCLBuffer)this.args[0];
        ClearCLBuffer adjacency_matrix = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().touchMatrixToAdjacencyMatrix(touch_matrix, adjacency_matrix);
    }

    public static boolean touchMatrixToAdjacencyMatrix(CLIJ2 clij2, ClearCLBuffer touch_matrix, ClearCLBuffer adjacency_matrix) {
        ClearCLBuffer temp = clij2.create(touch_matrix);
        clij2.transposeXY(touch_matrix, temp);
        clij2.addImages((ClearCLImageInterface)temp, (ClearCLImageInterface)touch_matrix, (ClearCLImageInterface)adjacency_matrix);
        temp.close();
        return true;
    }

    public String getDescription() {
        return "Converts a touch matrix in an adjacency matrix";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

