/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij.utilities.AffineTransform;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.realtransform.AffineTransform2D;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_translate2D")
public class Translate2D
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Image";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Transform";
    }

    public Object[] getDefaultValues() {
        return new Object[]{null, null, 0, 0};
    }

    public boolean executeCL() {
        float translateX = -Translate2D.asFloat((Object)this.args[2]).floatValue();
        float translateY = -Translate2D.asFloat((Object)this.args[3]).floatValue();
        ClearCLBuffer input = (ClearCLBuffer)this.args[0];
        ClearCLBuffer output = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().translate2D(input, output, translateX, translateY);
    }

    public static boolean translate2D(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float translateX, Float translateY) {
        AffineTransform2D at = new AffineTransform2D();
        at.translate(new double[]{-translateX.floatValue(), -translateY.floatValue()});
        if (!clij2.hasImageSupport()) {
            return clij2.affineTransform2D(input, (ClearCLImageInterface)output, AffineTransform.matrixToFloatArray2D((AffineTransform2D)at));
        }
        ClearCLImage image = clij2.create(input.getDimensions(), ImageChannelDataType.Float);
        clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)image);
        clij2.affineTransform2D(image, (ClearCLImageInterface)output, AffineTransform.matrixToFloatArray2D((AffineTransform2D)at));
        clij2.release((ClearCLImageInterface)image);
        return true;
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number translateX, Number translateY";
    }

    public String getDescription() {
        return "Translate an image stack in X and Y.";
    }

    public String getAvailableForDimensions() {
        return "2D";
    }
}

