/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import ij.measure.ResultsTable;
import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.MeanOfMaskedPixels;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_varianceOfMaskedPixels")
public class VarianceOfMaskedPixels
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized {
    public String getCategories() {
        return "Binary, Measurement";
    }

    public boolean executeCL() {
        double minVal = this.getCLIJ2().varianceOfMaskedPixels((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
        ResultsTable table = ResultsTable.getResultsTable();
        table.incrementCounter();
        table.addValue("Masked_variance", minVal);
        table.show("Results");
        return true;
    }

    public static double varianceOfMaskedPixels(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer mask) {
        double meanIntensity = MeanOfMaskedPixels.meanOfMaskedPixels(clij2, buffer1, mask);
        return VarianceOfMaskedPixels.varianceOfMaskedPixels(clij2, buffer1, mask, new Float(meanIntensity));
    }

    public static double varianceOfMaskedPixels(CLIJ2 clij2, ClearCLBuffer buffer1, ClearCLBuffer mask, Float meanIntensity) {
        HashMap<String, Object> parameters;
        ClearCLBuffer clReducedImage = buffer1;
        float sum = 0.0f;
        if (buffer1.getDimension() == 3L) {
            clReducedImage = clij2.create(new long[]{buffer1.getWidth(), buffer1.getHeight()}, NativeTypeEnum.Float);
            parameters = new HashMap<String, Object>();
            parameters.put("src", buffer1);
            parameters.put("src_mask", mask);
            parameters.put("dst", clReducedImage);
            parameters.put("mean_intensity", meanIntensity);
            clij2.execute(VarianceOfMaskedPixels.class, "variance_masked_projection_x.cl", "masked_squared_sum_project", clReducedImage.getDimensions(), clReducedImage.getDimensions(), parameters);
        } else {
            clReducedImage = clij2.create(new long[]{buffer1.getWidth(), buffer1.getHeight()}, NativeTypeEnum.Float);
            parameters = new HashMap();
            parameters.put("src", buffer1);
            parameters.put("src_mask", mask);
            parameters.put("dst", clReducedImage);
            parameters.put("mean_intensity", meanIntensity);
            clij2.execute(VarianceOfMaskedPixels.class, "variance_2d_x.cl", "masked_squared_sum_2d_2d", clReducedImage.getDimensions(), clReducedImage.getDimensions(), parameters);
        }
        RandomAccessibleInterval rai = clij2.convert(clReducedImage, RandomAccessibleInterval.class);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)rai).cursor();
        while (cursor.hasNext()) {
            sum += ((RealType)cursor.next()).getRealFloat();
        }
        clReducedImage.close();
        return (double)sum / clij2.sumPixels((ClearCLImageInterface)mask);
    }

    public String getParameterHelpText() {
        return "Image source, Image mask";
    }

    public String getDescription() {
        return "Determines the variance in an image, but only in pixels which have non-zero values in another binary mask image. \n\nThe result is put in the results table as new column named 'Masked_variance'.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

