/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.ClearCLImage;
import net.haesleinhuepf.clij.clearcl.enums.ImageChannelDataType;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.plugins.VoronoiLabeling;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_voronoiOctagon")
public class VoronoiOctagon
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Binary Image";
    }

    @Override
    public String getOutputType() {
        return "Binary Image";
    }

    public String getCategories() {
        return "Binary, Filter";
    }

    public boolean executeCL() {
        return this.getCLIJ2().voronoiOctagon((ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
    }

    public static boolean voronoiOctagon(CLIJ2 clij2, ClearCLBuffer src, ClearCLBuffer dst) {
        ClearCLImage flip = clij2.create(dst.getDimensions(), ImageChannelDataType.Float);
        VoronoiLabeling.voronoiLabeling(clij2, src, (ClearCLImageInterface)flip);
        clij2.detectLabelEdges((ClearCLImageInterface)flip, dst);
        clij2.release((ClearCLImageInterface)flip);
        return true;
    }

    public String getParameterHelpText() {
        return "Image input, ByRef Image destination";
    }

    public String getDescription() {
        return "Takes a binary image and dilates the regions using a octagon shape until they touch. \n\nThe pixels where  the regions touched are afterwards returned as binary image which corresponds to the Voronoi diagram.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

