/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.plugins;

import java.util.HashMap;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJ2_writeValuesToPositions")
public class WriteValuesToPositions
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    @Override
    public String getInputType() {
        return "Pointlist";
    }

    @Override
    public String getOutputType() {
        return "Image";
    }

    public String getCategories() {
        return "Visualisation";
    }

    public boolean executeCL() {
        ClearCLBuffer positionsAndValues = (ClearCLBuffer)this.args[0];
        ClearCLBuffer buffer = (ClearCLBuffer)this.args[1];
        return this.getCLIJ2().writeValuesToPositions(positionsAndValues, buffer);
    }

    public static boolean writeValuesToPositions(CLIJ2 clij2, ClearCLBuffer positionsAndValues, ClearCLBuffer dst) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("src", positionsAndValues);
        parameters.put("dst", dst);
        long[] size = new long[]{positionsAndValues.getWidth(), 1L, 1L};
        clij2.execute(WriteValuesToPositions.class, "write_values_to_positions_" + dst.getDimension() + "d_x.cl", "write_values_to_positions_" + dst.getDimension() + "d", size, size, parameters);
        return true;
    }

    public String getParameterHelpText() {
        return "Image positions_and_values, ByRef Image destination";
    }

    public String getDescription() {
        return "Takes an image with three/four rows (2D: height = 3; 3D: height = 4): x, y [, z] and v and target image. \n\nThe value v will be written at position x/y[/z] in the target image.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }
}

