/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij2.utilities;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import java.util.ArrayList;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.converters.CLIJConverterService;
import net.haesleinhuepf.clij.macro.CLIJHandler;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>ImageJ on GPU (CLIJ2)>CLIJ2 Macro Extensions")
public class CLIJ2MacroExtensions
implements Command {
    @Parameter
    CLIJConverterService clijConverterService;
    private static boolean warnedOutdatedOpenCLVersion = false;

    public void run() {
        ArrayList deviceList = CLIJ.getAvailableDeviceNames();
        String[] deviceArray = new String[deviceList.size()];
        deviceList.toArray(deviceArray);
        GenericDialog gd = new GenericDialog("CLIJ");
        gd.addChoice("CL_Device", deviceArray, deviceArray[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        CLIJ clij = CLIJ.getInstance((String)gd.getNextChoice());
        CLIJHandler.automaticOutputVariableNaming = true;
        this.clijConverterService.setCLIJ(clij);
        clij.setConverterService(this.clijConverterService);
        if (!warnedOutdatedOpenCLVersion && clij.getOpenCLVersion() < 1.2) {
            IJ.log((String)"Warning: Your GPU does not support OpenCL 1.2. Some operations may not work precisely. For example: CLIJ does not support linear interpolation; it uses nearest-neighbor interpolation instead. Consider upgrading GPU Driver version or GPU hardware.");
            warnedOutdatedOpenCLVersion = true;
        }
        if (!IJ.macroRunning()) {
            IJ.error((String)"Cannot install extensions from outside a macro.");
            return;
        }
        Functions.registerExtensions((MacroExtension)CLIJHandler.getInstance());
    }
}

