/*
 * Decompiled with CFR 0.152.
 */
package net.happyonroad.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromDependencies.CopyDependenciesMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="package", inheritByDefault=false, defaultPhase=LifecyclePhase.PACKAGE)
public class SpringComponentPackaging
extends CopyDependenciesMojo {
    @Parameter
    private File output;
    @Parameter(defaultValue="1099")
    private int appPort;
    @Parameter(defaultValue="")
    private String jvmOptions;
    @Parameter
    private String appName;
    @Parameter
    private Properties properties;
    @Parameter
    private File propertiesFile;
    @Parameter
    private File logbackFile;
    private static String lineSeparator = System.getProperty("os.name").contains("Windows") ? "\r\n" : "\n";

    public void doExecute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Hello, I'm packaging to " + this.output.getPath()));
        this.initAppParams();
        this.prepareFolders();
        this.copyTargets();
        this.copyDependencies();
        this.moveBootstrapJar();
        this.generateScripts();
    }

    private void initAppParams() {
        if (this.appName == null || StringUtils.isBlank((String)this.appName)) {
            String string = this.appName = this.project.getName() == null ? this.project.getArtifactId() : this.project.getName();
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    private void prepareFolders() throws MojoExecutionException {
        String[] subFolders;
        if (!this.output.exists()) {
            FileUtils.mkdir((String)this.output.getAbsolutePath());
        }
        for (String relativePath : subFolders = new String[]{"bin", "boot", "lib", "lib/poms", "config", "repository"}) {
            try {
                this.prepareFolder(relativePath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't prepare sub folder " + relativePath + " in " + this.output.getPath());
            }
        }
    }

    private void copyTargets() throws MojoExecutionException {
        String fileName = this.project.getGroupId() + "." + this.project.getArtifactId() + "-" + this.project.getVersion();
        File targetFile = new File(this.project.getBasedir(), "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar");
        try {
            FileUtils.copyFile((File)this.project.getFile(), (File)new File(this.output, "lib/poms/" + fileName + ".pom"));
            FileUtils.copyFile((File)targetFile, (File)new File(this.output, "lib/" + fileName + ".jar"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't copy targets: " + e.getMessage());
        }
    }

    private void copyDependencies() throws MojoExecutionException {
        File libPath = new File(this.output, "lib");
        super.setOutputDirectory(libPath);
        super.setCopyPom(true);
        super.setPrependGroupId(true);
        this.addParentPoms = true;
        HashSet<String> scope = new HashSet<String>();
        scope.add("test");
        this.getProject().setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(scope));
        super.doExecute();
    }

    private void moveBootstrapJar() throws MojoExecutionException {
        List bootJars;
        File libPath = new File(this.output, "lib");
        try {
            bootJars = FileUtils.getFiles((File)libPath, (String)"net.happyonroad.spring-component-framework-*.jar", null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't search " + libPath.getPath() + " for net.happyonroad.spring-component-framework-*.jar");
        }
        if (bootJars.isEmpty()) {
            throw new MojoExecutionException("You should configure a runtime dependency to net.happyonroad.spring-component-framework!");
        }
        if (bootJars.size() > 1) {
            throw new MojoExecutionException("There are more than one net.happyonroad.spring-component-framework");
        }
        File bootJar = (File)bootJars.get(0);
        File destJar = new File(this.output, "boot/" + bootJar.getName());
        try {
            FileUtils.rename((File)bootJar, (File)destJar);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't move boot jar:" + e.getMessage());
        }
        String bootPom = bootJar.getPath().replace(".jar", ".pom");
        try {
            FileUtils.forceDelete((String)bootPom);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Can't delete unnecessary boot pom " + bootPom + " :" + e.getMessage()));
        }
        try {
            List pomFiles = FileUtils.getFiles((File)libPath, (String)"*.pom", null);
            for (File pomFile : pomFiles) {
                File newPomFile = new File(libPath, "poms/" + pomFile.getName());
                FileUtils.rename((File)pomFile, (File)newPomFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't move poms: " + e.getMessage());
        }
    }

    private void generateScripts() throws MojoExecutionException {
        String target = String.format("%s.%s-%s", this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        try {
            String[] resourceNames;
            List bootJars = FileUtils.getFileNames((File)new File(this.output, "boot"), (String)"net.happyonroad.spring-component-framework-*.jar", null, (boolean)false);
            String bootJarName = "boot/" + (String)bootJars.get(0);
            HashMap<String, Object> replaces = new HashMap<String, Object>();
            replaces.put("app.id", this.project.getArtifactId());
            replaces.put("app.name", this.replaceSpaces(this.appName));
            replaces.put("app.port", this.appPort);
            replaces.put("app.boot", bootJarName);
            replaces.put("app.target", target);
            replaces.put("jvm.options", this.jvmOptions);
            for (String resource : resourceNames = new String[]{"start.bat", "start.sh", "stop.bat", "stop.sh"}) {
                this.copyResource(resource, "bin", replaces);
            }
            if (this.logbackFile != null && this.logbackFile.exists()) {
                this.copyFile(this.logbackFile, replaces);
            } else {
                this.copyResource("logback.xml", "config", replaces);
            }
            if (this.propertiesFile != null && this.propertiesFile.exists()) {
                this.copyFile(this.propertiesFile, replaces);
            } else {
                File propertiesFile = new File(this.output, "config/" + this.project.getArtifactId() + ".properties");
                FileOutputStream fos = new FileOutputStream(propertiesFile);
                this.properties.store(fos, this.appName + " Properties");
                fos.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't generate script");
        }
    }

    private Object replaceSpaces(String appName) {
        return appName.replaceAll("\\s", "_");
    }

    private void copyFile(File file, Map<String, Object> replaces) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        List lines = IOUtils.readLines((InputStream)fis);
        String content = StringUtils.join((Collection)lines, (String)lineSeparator);
        String interpolated = this.interpolate(content, replaces);
        FileUtils.fileWrite((File)new File(this.output, "config/" + file.getName()), (String)interpolated);
    }

    private void copyResource(String resource, String path, Map<String, Object> replaces) throws IOException {
        String content = this.read(resource);
        String interpolated = this.interpolate(content, replaces);
        FileUtils.fileWrite((File)new File(this.output, path + "/" + resource), (String)interpolated);
    }

    private String read(String resource) throws IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        List lines = IOUtils.readLines((InputStream)stream);
        return StringUtils.join((Collection)lines, (String)lineSeparator);
    }

    private String interpolate(String content, Map<String, Object> replaces) {
        String newContent = content;
        for (String key : replaces.keySet()) {
            String compiledKey = key.replace(".", "\\.");
            Object o = replaces.get(key);
            newContent = newContent.replaceAll("\\$\\{" + compiledKey + "\\}", o == null ? "" : o.toString());
        }
        return newContent;
    }

    private void prepareFolder(String relativePath) throws IOException {
        File subFolder = new File(this.output, relativePath);
        if (subFolder.exists()) {
            FileUtils.cleanDirectory((File)subFolder);
        } else {
            FileUtils.forceMkdir((File)subFolder);
        }
    }
}

