/*
 * Decompiled with CFR 0.152.
 */
package org.lineargs;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.lineargs.ListOption;
import org.lineargs.NonameOption;
import org.lineargs.Option;
import org.lineargs.constraints.RangeConstraint;
import org.lineargs.constraints.RegexConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineArgsParser {
    public <T> T parse(Class<T> objClass, String[] args) throws Exception {
        T object = objClass.newInstance();
        return this.parse(object, args);
    }

    public <T> T parse(T object, String[] args) throws Exception {
        this.parseArguments(object, args);
        return object;
    }

    protected void parseArguments(Object object, String[] args) throws Exception {
        LinkedList<Field> installedFields = new LinkedList<Field>();
        for (int currentArg = 0; currentArg < args.length; ++currentArg) {
            Field[] fields = object.getClass().getDeclaredFields();
            int idx = 0;
            for (idx = 0; idx < fields.length; ++idx) {
                Field field = fields[idx];
                String arg = args[currentArg];
                String name = this.getFieldName(field);
                String shortName = this.getFieldShortName(field);
                if (!installedFields.contains(field) && (name != null && arg.equals(name) || shortName != null && shortName.length() > 0 && arg.equals(shortName))) {
                    currentArg = this.parseArgument(object, field, args, currentArg);
                    installedFields.add(field);
                    break;
                }
                if (!field.isAnnotationPresent(NonameOption.class) || installedFields.contains(field)) continue;
                currentArg = this.parseNoname(object, field, args, currentArg);
                installedFields.add(field);
                break;
            }
            if (idx != fields.length) continue;
            throw new Exception("Unknown option: " + args[currentArg]);
        }
        this.checkMandatoryFields(object, installedFields);
    }

    protected int parseArgument(Object object, Field field, String[] args, int currentArg) throws Exception {
        if (field.isAnnotationPresent(ListOption.class)) {
            currentArg = this.parseSeparated(object, field, args, currentArg);
        } else if (field.isAnnotationPresent(Option.class)) {
            currentArg = this.parseOption(object, field, args, currentArg);
        }
        return currentArg;
    }

    protected int parseOption(Object object, Field field, String[] args, int currentArg) throws Exception {
        Option meta = field.getAnnotation(Option.class);
        Class<?> objClass = field.getType();
        Boolean value = null;
        if (!objClass.equals(Boolean.class)) {
            if (++currentArg >= args.length) {
                throw new Exception("Value for option " + meta.name() + " is unspecified!");
            }
            Constructor<?> constructor = objClass.getConstructor(String.class);
            value = constructor.newInstance(args[currentArg]);
        } else {
            value = true;
        }
        this.checkConstraints(meta.name(), value, field);
        this.setFieldValue(object, field, value);
        return currentArg;
    }

    protected void checkConstraints(String optionName, Object obj, Field field) throws Exception {
        String strValue;
        Annotation constraint;
        if (obj instanceof Integer) {
            Integer value = (Integer)obj;
            if (field.isAnnotationPresent(RangeConstraint.class)) {
                constraint = field.getAnnotation(RangeConstraint.class);
                if (value > constraint.maxValue() || value < constraint.minValue()) {
                    throw new Exception("Specified value for option " + optionName + " is incorrect!");
                }
            }
        } else if (field.isAnnotationPresent(RangeConstraint.class)) {
            strValue = obj.toString();
            constraint = field.getAnnotation(RangeConstraint.class);
            if (strValue.length() > constraint.maxValue() || strValue.length() < constraint.minValue()) {
                throw new Exception("Specified value for option " + optionName + " has incorrect length!");
            }
        }
        if (field.isAnnotationPresent(RegexConstraint.class) && !(strValue = obj.toString()).matches((constraint = field.getAnnotation(RegexConstraint.class)).mask())) {
            throw new Exception("Specified value for option " + optionName + " is incorrect!");
        }
    }

    protected int parseSeparated(Object object, Field field, String[] args, int currentArg) throws Exception {
        ListOption meta = field.getAnnotation(ListOption.class);
        if (++currentArg >= args.length) {
            throw new Exception("Value for option " + meta.name() + " is unspecified!");
        }
        String value = args[currentArg];
        StringTokenizer strTokenizer = new StringTokenizer(value, meta.delimeter(), false);
        ParameterizedType tp = (ParameterizedType)field.getGenericType();
        Class paramType = (Class)tp.getActualTypeArguments()[0];
        LinkedList param = new LinkedList();
        while (strTokenizer.hasMoreTokens()) {
            String token = strTokenizer.nextToken();
            Constructor constructor = paramType.getConstructor(String.class);
            Object tokenValue = constructor.newInstance(token);
            this.checkConstraints(meta.name(), tokenValue, field);
            param.add(tokenValue);
        }
        this.setFieldValue(object, field, param);
        return currentArg;
    }

    protected int parseNoname(Object object, Field field, String[] args, int currentArg) throws Exception {
        NonameOption meta = field.getAnnotation(NonameOption.class);
        Class<?> objClass = field.getType();
        Constructor<?> constructor = objClass.getConstructor(String.class);
        Object value = constructor.newInstance(args[currentArg]);
        this.checkConstraints("<value>", value, field);
        this.setFieldValue(object, field, value);
        return currentArg;
    }

    protected void checkMandatoryFields(Object object, Collection<Field> installedFields) throws Exception {
        for (Field field : object.getClass().getDeclaredFields()) {
            if (this.isFieldOptional(field) || installedFields.contains(field)) continue;
            if (field.isAnnotationPresent(NonameOption.class)) {
                throw new Exception("Unable to present mandatory argument (" + this.getFieldDescription(field) + ")");
            }
            throw new Exception("Unable to present value for mandatory option " + this.getFieldName(field));
        }
    }

    protected boolean isFieldOptional(Field field) {
        if (field.isAnnotationPresent(Option.class)) {
            return field.getAnnotation(Option.class).isOptional();
        }
        if (field.isAnnotationPresent(NonameOption.class)) {
            return field.getAnnotation(NonameOption.class).isOptional();
        }
        if (field.isAnnotationPresent(ListOption.class)) {
            return field.getAnnotation(ListOption.class).isOptional();
        }
        return true;
    }

    protected String getFieldDescription(Field field) {
        if (field.isAnnotationPresent(Option.class)) {
            return field.getAnnotation(Option.class).description();
        }
        if (field.isAnnotationPresent(NonameOption.class)) {
            return field.getAnnotation(NonameOption.class).description();
        }
        if (field.isAnnotationPresent(ListOption.class)) {
            return field.getAnnotation(ListOption.class).description();
        }
        return null;
    }

    protected String getFieldName(Field field) {
        if (field.isAnnotationPresent(Option.class)) {
            return field.getAnnotation(Option.class).name();
        }
        if (field.isAnnotationPresent(ListOption.class)) {
            return field.getAnnotation(ListOption.class).name();
        }
        return null;
    }

    protected String getFieldShortName(Field field) {
        if (field.isAnnotationPresent(Option.class)) {
            return field.getAnnotation(Option.class).shortName();
        }
        if (field.isAnnotationPresent(ListOption.class)) {
            return field.getAnnotation(ListOption.class).shortName();
        }
        return null;
    }

    protected Object getFieldValue(Object object, Field field) throws Exception {
        String methodName = "get" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        Method method = this.findMethodForField(methodName, object, null);
        return method.invoke(object, (Object[])null);
    }

    protected void setFieldValue(Object object, Field field, Object param) throws Exception {
        String methodName = "set" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        Method method = this.findMethodForField(methodName, object, param);
        method.invoke(object, param);
    }

    protected Method findMethodForField(String methodName, Object object, Object param) throws NoSuchMethodException {
        try {
            return object.getClass().getMethod(methodName, param != null ? param.getClass() : null);
        }
        catch (NoSuchMethodException ex) {
            Method[] methods;
            for (Method method : methods = object.getClass().getMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
            throw ex;
        }
    }

    public <T> void printHelp(Class<T> objClass, PrintStream stream) throws Exception {
        for (Field field : objClass.getDeclaredFields()) {
            String fieldHelp = this.getHelpForField(field);
            if (fieldHelp == null) continue;
            stream.println(fieldHelp);
        }
    }

    protected String getHelpForField(Field field) {
        boolean hasArgument;
        String name = this.getFieldName(field);
        String shortName = this.getFieldShortName(field);
        Class<?> objClass = field.getType();
        if (name == null) {
            if (!field.isAnnotationPresent(NonameOption.class)) {
                return null;
            }
            name = "";
        }
        boolean isOptional = this.isFieldOptional(field);
        boolean bl = hasArgument = !objClass.equals(Boolean.class);
        if (field.isAnnotationPresent(NonameOption.class)) {
            return String.format("%1$37s", "" + (isOptional ? "[" : "") + "<value>" + (isOptional ? "[" : "") + " : ") + this.getFieldDescription(field);
        }
        return String.format("%1$18s %2$8s %3$6s : %4$s", "" + (isOptional ? "[" : "") + name + ",", shortName + (isOptional ? "]" : ""), hasArgument ? " <arg>" : "", this.getFieldDescription(field));
    }
}

