/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.ber;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import org.bn.coders.CoderUtils;
import org.bn.coders.DecodedObject;
import org.bn.coders.Decoder;
import org.bn.coders.ElementInfo;
import org.bn.coders.ber.BERCoderUtils;
import org.bn.coders.ber.BERObjectIdentifier;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;

public class BERDecoder
extends Decoder {
    protected DecodedObject<Integer> decodeLength(InputStream stream) throws Exception {
        int result = 0;
        int bt = stream.read();
        if (bt == -1) {
            throw new IllegalArgumentException("Unexpected EOF when decoding!");
        }
        int len = 1;
        if (bt < 128) {
            result = bt;
        } else {
            for (int i = bt - 128; i > 0; --i) {
                int fBt = stream.read();
                if (fBt == -1) {
                    throw new IllegalArgumentException("Unexpected EOF when decoding!");
                }
                result <<= 8;
                result |= fBt;
                ++len;
            }
        }
        return new DecodedObject<Integer>(result, len);
    }

    @Override
    public DecodedObject<Integer> decodeTag(InputStream stream) throws Exception {
        int len;
        int bt = stream.read();
        if (bt == -1) {
            return null;
        }
        int result = bt;
        int tagValue = bt & 0x1F;
        if (tagValue == 31) {
            bt = 128;
            for (len = 1; (bt & 0x80) != 0 && len < 4; ++len) {
                result <<= 8;
                bt = stream.read();
                if (bt != -1) {
                    result |= bt;
                    continue;
                }
                result >>= 8;
                break;
            }
        }
        return new DecodedObject<Integer>(result, len);
    }

    protected boolean checkTagForObject(DecodedObject<Integer> decodedTag, int tagClass, int elementType, int universalTag, ElementInfo elementInfo) {
        if (decodedTag == null) {
            return false;
        }
        int definedTag = BERCoderUtils.getTagValueForElement(elementInfo, tagClass, elementType, universalTag).getValue();
        return definedTag == decodedTag.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DecodedObject decodeSequence(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        boolean isSet = false;
        if (CoderUtils.isSequenceSet(elementInfo)) {
            if (!this.checkTagForObject(decodedTag, 0, 32, 17, elementInfo)) return null;
            isSet = true;
        } else if (!this.checkTagForObject(decodedTag, 0, 32, 16, elementInfo)) {
            return null;
        }
        DecodedObject<Integer> len = this.decodeLength(stream);
        int saveMaxAvailableLen = elementInfo.getMaxAvailableLen();
        elementInfo.setMaxAvailableLen(len.getValue());
        DecodedObject result = isSet ? this.decodeSet(decodedTag, objectClass, elementInfo, len.getValue(), stream) : super.decodeSequence(decodedTag, objectClass, elementInfo, stream);
        if (result.getSize() != len.getValue().intValue()) {
            throw new IllegalArgumentException("Sequence '" + objectClass.toString() + "' size is incorrect! Must be: " + len.getValue() + ". Received: " + result.getSize());
        }
        result.setSize(result.getSize() + len.getSize());
        elementInfo.setMaxAvailableLen(saveMaxAvailableLen);
        return result;
    }

    protected DecodedObject decodeSet(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, Integer len, InputStream stream) throws Exception {
        Object set = this.createInstanceForElement(objectClass, elementInfo);
        CoderUtils.initDefaultValues(set);
        int maxSeqLen = elementInfo.getMaxAvailableLen();
        int sizeOfSet = 0;
        DecodedObject<Integer> fieldTag = null;
        if (maxSeqLen == -1 || maxSeqLen > 0) {
            fieldTag = this.decodeTag(stream);
        }
        if (fieldTag != null) {
            sizeOfSet += fieldTag.getSize();
        }
        Field[] fields = elementInfo.getFields(objectClass);
        boolean fieldEncoded = false;
        block0: do {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                DecodedObject obj = this.decodeSequenceField(fieldTag, set, i, field, stream, elementInfo, false);
                if (obj == null) continue;
                fieldEncoded = true;
                sizeOfSet += obj.getSize();
                boolean isAny = false;
                if (i + 1 == fields.length - 1) {
                    ElementInfo info = new ElementInfo();
                    info.setAnnotatedClass(fields[i + 1]);
                    info.setMaxAvailableLen(elementInfo.getMaxAvailableLen());
                    info.setGenericInfo(field.getGenericType());
                    if (elementInfo.hasPreparedInfo()) {
                        info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(i + 1));
                    } else {
                        info.setASN1ElementInfoForClass(fields[i + 1]);
                    }
                    isAny = CoderUtils.isAnyField(fields[i + 1], info);
                }
                if (maxSeqLen != -1) {
                    elementInfo.setMaxAvailableLen(maxSeqLen - sizeOfSet);
                }
                if (isAny) continue;
                if (i >= fields.length - 1) continue block0;
                if (maxSeqLen == -1 || elementInfo.getMaxAvailableLen() > 0) {
                    fieldTag = this.decodeTag(stream);
                    if (fieldTag == null) continue block0;
                    sizeOfSet += fieldTag.getSize();
                    continue;
                }
                fieldTag = null;
            }
        } while (sizeOfSet < len && fieldEncoded);
        return new DecodedObject<Object>(set, sizeOfSet);
    }

    @Override
    public DecodedObject<Integer> decodeEnumItem(DecodedObject<Integer> decodedTag, Class objectClass, Class enumClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 10, elementInfo)) {
            return null;
        }
        return this.decodeIntegerValue(stream);
    }

    @Override
    public DecodedObject<Boolean> decodeBoolean(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 1, elementInfo)) {
            return null;
        }
        DecodedObject<Integer> intVal = this.decodeIntegerValue(stream);
        DecodedObject<Boolean> result = new DecodedObject<Boolean>(false, intVal.getSize());
        if (intVal.getValue() != 0) {
            result.setValue(true);
        }
        return result;
    }

    @Override
    public DecodedObject<byte[]> decodeAny(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        int bufSize = elementInfo.getMaxAvailableLen();
        if (bufSize == 0) {
            return null;
        }
        ByteArrayOutputStream anyStream = new ByteArrayOutputStream(1024);
        if (bufSize < 0) {
            bufSize = 1024;
        }
        int len = 0;
        if (bufSize > 0) {
            byte[] buffer = new byte[bufSize];
            int readed = stream.read(buffer);
            while (readed > 0) {
                anyStream.write(buffer, 0, readed);
                len += readed;
                if (elementInfo.getMaxAvailableLen() > 0) break;
                readed = stream.read(buffer);
            }
        }
        CoderUtils.checkConstraints(len, elementInfo);
        return new DecodedObject<byte[]>(anyStream.toByteArray(), len);
    }

    @Override
    public <T> DecodedObject<T> decodeNull(DecodedObject<Integer> decodedTag, Class<T> objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 5, elementInfo)) {
            return null;
        }
        stream.read();
        return new DecodedObject<T>(objectClass.newInstance(), 1);
    }

    @Override
    public DecodedObject<? extends Number> decodeInteger(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 2, elementInfo)) {
            return null;
        }
        if (objectClass.equals(Integer.class)) {
            DecodedObject<Integer> result = this.decodeIntegerValue(stream);
            CoderUtils.checkConstraints(result.getValue().intValue(), elementInfo);
            return result;
        }
        DecodedObject<Long> result = this.decodeLongValue(stream);
        CoderUtils.checkConstraints(result.getValue(), elementInfo);
        return result;
    }

    @Override
    public DecodedObject<Double> decodeReal(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 9, elementInfo)) {
            return null;
        }
        DecodedObject<Integer> len = this.decodeLength(stream);
        int realPreamble = stream.read();
        Double result = 0.0;
        if (realPreamble == 64) {
            result = Double.POSITIVE_INFINITY;
        } else if (realPreamble == 65) {
            result = Double.NEGATIVE_INFINITY;
        } else if (len.getValue() > 0) {
            int szOfExp = 1 + (realPreamble & 3);
            int sign = realPreamble & 0x40;
            int ff = (realPreamble & 0xC) >> 2;
            DecodedObject<Long> exponentEncFrm = this.decodeLongValue(stream, new DecodedObject<Integer>(szOfExp));
            long exponent = exponentEncFrm.getValue();
            DecodedObject<Long> mantissaEncFrm = this.decodeLongValue(stream, new DecodedObject<Integer>(len.getValue() - szOfExp - 1));
            long mantissa = mantissaEncFrm.getValue() << ff;
            while ((mantissa & 0xFF00000000000L) == 0L) {
                exponent -= 8L;
                mantissa <<= 8;
            }
            while ((mantissa & 0x10000000000000L) == 0L) {
                --exponent;
                mantissa <<= 1;
            }
            long lValue = exponent + 1023L + 52L << 52;
            lValue |= (mantissa &= 0xFFFFFFFFFFFFFL);
            if (sign == 64) {
                lValue |= Long.MIN_VALUE;
            }
            result = Double.longBitsToDouble(lValue);
        }
        return new DecodedObject<Double>(result, len.getValue() + len.getSize());
    }

    @Override
    public DecodedObject decodeChoice(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (elementInfo.hasPreparedInfo() && elementInfo.hasPreparedASN1ElementInfo() && elementInfo.getPreparedASN1ElementInfo().hasTag() || elementInfo.getASN1ElementInfo() != null && elementInfo.getASN1ElementInfo().hasTag()) {
            if (!this.checkTagForObject(decodedTag, 128, 32, 31, elementInfo)) {
                return null;
            }
            DecodedObject<Integer> lenOfChild = this.decodeLength(stream);
            DecodedObject<Integer> childDecodedTag = this.decodeTag(stream);
            DecodedObject result = super.decodeChoice(childDecodedTag, objectClass, elementInfo, stream);
            result.setSize(result.getSize() + childDecodedTag.getSize() + lenOfChild.getSize());
            return result;
        }
        return super.decodeChoice(decodedTag, objectClass, elementInfo, stream);
    }

    protected DecodedObject<Integer> decodeIntegerValue(InputStream stream) throws Exception {
        DecodedObject<Long> lVal = this.decodeLongValue(stream);
        DecodedObject<Integer> result = new DecodedObject<Integer>((int)lVal.getValue().longValue(), lVal.getSize());
        return result;
    }

    protected DecodedObject<Long> decodeLongValue(InputStream stream) throws Exception {
        DecodedObject<Integer> len = this.decodeLength(stream);
        return this.decodeLongValue(stream, len);
    }

    public DecodedObject<Long> decodeLongValue(InputStream stream, DecodedObject<Integer> len) throws Exception {
        long value = 0L;
        for (int i = 0; i < len.getValue(); ++i) {
            int bt = stream.read();
            if (bt == -1) {
                throw new IllegalArgumentException("Unexpected EOF when decoding!");
            }
            if (i == 0 && (bt & 0xFFFFFF80) != 0) {
                bt -= 256;
            }
            value = value << 8 | (long)bt;
        }
        return new DecodedObject<Long>(value, len.getValue() + len.getSize());
    }

    @Override
    public DecodedObject<byte[]> decodeOctetString(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 4, elementInfo)) {
            return null;
        }
        DecodedObject<Integer> len = this.decodeLength(stream);
        CoderUtils.checkConstraints(len.getValue().intValue(), elementInfo);
        byte[] byteBuf = new byte[len.getValue().intValue()];
        stream.read(byteBuf);
        return new DecodedObject<byte[]>(byteBuf, len.getValue() + len.getSize());
    }

    @Override
    public DecodedObject<BitString> decodeBitString(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 3, elementInfo)) {
            return null;
        }
        DecodedObject<Integer> len = this.decodeLength(stream);
        int trailBitCnt = stream.read();
        CoderUtils.checkConstraints(len.getValue() * 8 - trailBitCnt, elementInfo);
        byte[] byteBuf = new byte[len.getValue() - 1];
        stream.read(byteBuf);
        return new DecodedObject<BitString>(new BitString(byteBuf, trailBitCnt), len.getValue() + len.getSize());
    }

    @Override
    public DecodedObject<String> decodeString(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, CoderUtils.getStringTagForElement(elementInfo), elementInfo)) {
            return null;
        }
        DecodedObject<Integer> len = this.decodeLength(stream);
        CoderUtils.checkConstraints(len.getValue().intValue(), elementInfo);
        byte[] byteBuf = new byte[len.getValue().intValue()];
        stream.read(byteBuf);
        String result = CoderUtils.bufferToASN1String(byteBuf, elementInfo);
        return new DecodedObject<String>(result, len.getValue() + len.getSize());
    }

    @Override
    public DecodedObject<Collection<Object>> decodeSequenceOf(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!CoderUtils.isSequenceSetOf(elementInfo) ? !this.checkTagForObject(decodedTag, 0, 32, 16, elementInfo) : !this.checkTagForObject(decodedTag, 0, 32, 17, elementInfo)) {
            return null;
        }
        LinkedList result = new LinkedList();
        DecodedObject<Integer> len = this.decodeLength(stream);
        if (len.getValue() != 0) {
            int lenOfItems = 0;
            int cntOfItems = 0;
            Class<?> paramType = CoderUtils.getCollectionType(elementInfo);
            do {
                DecodedObject<Integer> itemTag;
                DecodedObject<?> item;
                ElementInfo info = new ElementInfo();
                info.setAnnotatedClass(paramType);
                info.setParentAnnotated(elementInfo.getAnnotatedClass());
                if (elementInfo.hasPreparedInfo()) {
                    ASN1SequenceOfMetadata seqOfMeta = (ASN1SequenceOfMetadata)elementInfo.getPreparedInfo().getTypeMetadata();
                    info.setPreparedInfo(seqOfMeta.getItemClassMetadata());
                }
                if ((item = this.decodeClassType(itemTag = this.decodeTag(stream), paramType, info, stream)) == null) continue;
                lenOfItems += item.getSize() + itemTag.getSize();
                result.add(item.getValue());
                ++cntOfItems;
            } while (lenOfItems < len.getValue());
            CoderUtils.checkConstraints(cntOfItems, elementInfo);
        }
        return new DecodedObject<Collection<Object>>(result, len.getValue() + len.getSize());
    }

    @Override
    public DecodedObject<ObjectIdentifier> decodeObjectIdentifier(DecodedObject<Integer> decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        if (!this.checkTagForObject(decodedTag, 0, 0, 6, elementInfo)) {
            return null;
        }
        DecodedObject<Integer> len = this.decodeLength(stream);
        byte[] byteBuf = new byte[len.getValue().intValue()];
        stream.read(byteBuf, 0, byteBuf.length);
        String dottedDecimal = BERObjectIdentifier.Decode(byteBuf);
        return new DecodedObject<ObjectIdentifier>(new ObjectIdentifier(dottedDecimal));
    }
}

