/*
 * Decompiled with CFR 0.152.
 */
package org.bn.metadata;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.bn.annotations.ASN1SequenceOf;
import org.bn.coders.ASN1PreparedElementData;
import org.bn.coders.CoderUtils;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1TypesDecoder;
import org.bn.coders.IASN1TypesEncoder;
import org.bn.metadata.ASN1FieldMetadata;

public class ASN1SequenceOfMetadata
extends ASN1FieldMetadata {
    private boolean isSetOf = false;
    private Type itemClass;
    private ASN1PreparedElementData itemClassMetadata;

    public ASN1SequenceOfMetadata(String name, boolean isSetOf, Type itemClass, AnnotatedElement seqFieldAnnotatedElem) {
        super(name);
        this.isSetOf = isSetOf;
        this.itemClass = itemClass;
        Class<?> paramType = CoderUtils.getCollectionType((ParameterizedType)itemClass);
        this.itemClassMetadata = new ASN1PreparedElementData(paramType);
        if (this.itemClassMetadata.getTypeMetadata() != null) {
            this.itemClassMetadata.getTypeMetadata().setParentAnnotated(seqFieldAnnotatedElem);
        }
    }

    public ASN1SequenceOfMetadata(ASN1SequenceOf annotation, Type itemClass, AnnotatedElement seqFieldAnnotatedElem) {
        this(annotation.name(), annotation.isSetOf(), itemClass, seqFieldAnnotatedElem);
    }

    public boolean isSetOf() {
        return this.isSetOf;
    }

    public ASN1PreparedElementData getItemClassMetadata() {
        return this.itemClassMetadata;
    }

    @Override
    public int encode(IASN1TypesEncoder encoder, Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        return encoder.encodeSequenceOf(object, stream, elementInfo);
    }

    @Override
    public DecodedObject<?> decode(IASN1TypesDecoder decoder, DecodedObject<Integer> decodedTag, Class<?> objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        return decoder.decodeSequenceOf(decodedTag, objectClass, elementInfo, stream);
    }
}

