/*
 * Decompiled with CFR 0.152.
 */
package org.bn.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Module {
    private final String moduleName;
    private final String outputDir;
    private final List<String> moduleFiles;

    public Module(String moduleName, String outputDir) throws IOException, URISyntaxException {
        this.moduleName = moduleName;
        this.outputDir = outputDir;
        this.moduleFiles = new ArrayList<String>(1);
        URL modulesURL = this.getClass().getResource("/modules");
        if ("file".equals(modulesURL.getProtocol())) {
            File moduleFolder = new File(new File(modulesURL.toURI()), moduleName);
            if (moduleFolder.isDirectory()) {
                for (File file : moduleFolder.listFiles()) {
                    if (!file.isFile()) continue;
                    String filePath = file.getCanonicalPath().replace("\\", "/");
                    this.moduleFiles.add(filePath.substring(filePath.lastIndexOf("/modules/")));
                }
            }
        } else if ("jar".equals(modulesURL.getProtocol())) {
            String jarPath = modulesURL.getPath().substring(5, modulesURL.getPath().indexOf(33));
            Enumeration<JarEntry> entries = new JarFile(URLDecoder.decode(jarPath, "UTF-8")).entries();
            Pattern moduleFilePattern = Pattern.compile("modules/" + moduleName + "/[^/]+");
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!moduleFilePattern.matcher(entryName).matches()) continue;
                this.moduleFiles.add('/' + entryName);
            }
        } else {
            throw new IOException("Unexpected resource location: " + modulesURL);
        }
        if (this.moduleFiles.isEmpty()) {
            throw new IllegalArgumentException("Unknown module name '" + moduleName + "'");
        }
    }

    public void translate(InputStream stream) throws TransformerException {
        new File(this.outputDir).mkdirs();
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                String systemId = base.substring(0, base.lastIndexOf(47) + 1) + href;
                String resourcePath = systemId.substring(systemId.indexOf("/modules/"));
                return new StreamSource(this.getClass().getResourceAsStream(resourcePath), systemId);
            }
        });
        for (String xslFile : this.moduleFiles) {
            Transformer transformer = factory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(xslFile), xslFile));
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) {
                    System.err.println("[W] Warning:" + exception);
                }

                @Override
                public void error(TransformerException exception) {
                    System.err.println("[!] Error:" + exception);
                }

                @Override
                public void fatalError(TransformerException exception) {
                    System.err.println("[!!!] Fatal error:" + exception);
                }
            });
            File outputFile = this.createOutputFileForInput(xslFile.substring(xslFile.lastIndexOf(47) + 1));
            transformer.transform(new StreamSource(stream), new StreamResult(outputFile));
        }
    }

    private File createOutputFileForInput(String inputName) {
        return new File(this.getOutputDir(), inputName.substring(0, inputName.lastIndexOf(46)) + "." + this.getModuleName());
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getOutputDir() {
        return this.outputDir;
    }
}

