/*
 * Decompiled with CFR 0.152.
 */
package de.tisoft.rsyntaxtextarea.modes.antlr;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.misc.IntegerStack;

class ModeInfoManager {
    private int nextModeInternalToken = -1;
    private final Map<Integer, ModeInfo> tokenToModeInfo = new HashMap<Integer, ModeInfo>();
    private final Map<ModeInfo, Integer> modeInfoToToken = new HashMap<ModeInfo, Integer>();

    ModeInfoManager() {
    }

    ModeInfo getModeInfo(int initialTokenType) {
        ModeInfo modeInfo = initialTokenType < 0 ? this.tokenToModeInfo.get(initialTokenType) : new ModeInfo(initialTokenType, 0, new IntegerStack());
        return modeInfo;
    }

    int storeModeInfo(int currentType, int currentMode, IntegerStack modeStack) {
        ModeInfo modeInfo = new ModeInfo(currentType, currentMode, new IntegerStack(modeStack));
        Integer token = this.modeInfoToToken.get(modeInfo);
        if (token != null) {
            return token;
        }
        if (this.nextModeInternalToken > 0) {
            throw new ArrayIndexOutOfBoundsException(this.nextModeInternalToken);
        }
        this.tokenToModeInfo.put(this.nextModeInternalToken, modeInfo);
        this.modeInfoToToken.put(modeInfo, this.nextModeInternalToken);
        return this.nextModeInternalToken--;
    }

    static final class ModeInfo {
        final int tokenType;
        final int currentMode;
        final IntegerStack modeStack;

        ModeInfo(int tokenType, int currentMode, IntegerStack modeStack) {
            this.tokenType = tokenType;
            this.currentMode = currentMode;
            this.modeStack = modeStack;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModeInfo modeInfo = (ModeInfo)o;
            return this.tokenType == modeInfo.tokenType && this.currentMode == modeInfo.currentMode && this.modeStack.equals(modeInfo.modeStack);
        }

        public int hashCode() {
            return Objects.hash(this.tokenType, this.currentMode, this.modeStack);
        }
    }
}

