/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.bard.player;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.heberling.clanlord.bard.parser.MusicLexer;
import net.heberling.clanlord.bard.parser.MusicParser;
import net.heberling.clanlord.bard.player.BailErrorListener;
import net.heberling.clanlord.bard.player.InstrumentParameter;
import net.heberling.clanlord.bard.player.MusicException;
import net.heberling.clanlord.bard.player.Note;
import net.heberling.clanlord.bard.player.visitor.MusicVisitor;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;

public class MusicQueue {
    private TreeSet<Note> ts = new TreeSet();
    private Set<Integer> longChords = new HashSet<Integer>();
    private int nextNotePosition = 0;
    private int nextChordPosition = 0;
    private final int melodyChannel;
    private final int chordChannel;
    private final InstrumentParameter instrument;

    public MusicQueue(InstrumentParameter instrument, int melodyChannel, int chordChannel) {
        this.instrument = instrument;
        this.melodyChannel = melodyChannel;
        this.chordChannel = chordChannel;
    }

    public void parse(String s, int channel, int tempo, int volume) throws MusicException {
        MusicLexer musicLexer = new MusicLexer(CharStreams.fromString(s));
        musicLexer.addErrorListener(new BailErrorListener());
        MusicParser musicParser = new MusicParser(new CommonTokenStream(musicLexer));
        musicParser.addErrorListener(new BailErrorListener());
        try {
            MusicParser.SongContext song_return = musicParser.song();
            new MusicVisitor(this, tempo, volume).visit(song_return);
        }
        catch (BailErrorListener.BailException e) {
            throw new MusicException(channel, e.getMessage(), e.getStartIndex());
        }
        catch (RecognitionException e) {
            throw new MusicException(channel, musicParser.getErrorHeader(e) + " " + musicParser.getErrorHeader(e), e.getOffendingToken().getStartIndex());
        }
        catch (RuntimeException e) {
            RecognitionException e2 = (RecognitionException)e.getCause();
            throw new MusicException(channel, musicParser.getErrorHeader(e2) + " " + musicParser.getErrorHeader(e2), e2.getOffendingToken().getStartIndex());
        }
    }

    public int getMelodyChannel() {
        return this.melodyChannel;
    }

    public InstrumentParameter getInstrument() {
        return this.instrument;
    }

    public void addAllFromMusicQueue(MusicQueue q) {
        Note[] n = q.getNotes();
        this.ts.addAll(Arrays.asList(n));
    }

    public synchronized void addNote(int note, int vel, int noteLenght, int nextNote) {
        this.ts.add(new Note(this.nextNotePosition, note, vel, this.melodyChannel, this.instrument));
        this.ts.add(new Note(this.nextNotePosition + noteLenght, note, 0, this.melodyChannel, this.instrument));
        this.nextNotePosition += nextNote;
    }

    public synchronized void addPause(int duration) {
        this.nextNotePosition += duration;
    }

    public synchronized void addChord(int[] chord, int lenght, int vel, int chordLenght, int nextChord) {
        this.nextChordPosition = this.nextNotePosition;
        if (nextChord > 0) {
            int i;
            for (i = 0; i < lenght; ++i) {
                this.ts.add(new Note(this.nextChordPosition, chord[i], vel, this.chordChannel, this.instrument));
            }
            for (i = 0; i < lenght; ++i) {
                this.ts.add(new Note(this.nextChordPosition + chordLenght, chord[i], 0, this.chordChannel, this.instrument));
            }
        } else {
            for (int i = 0; i < lenght; ++i) {
                if (this.longChords.contains(chord[i])) {
                    this.ts.add(new Note(this.nextChordPosition, chord[i], 0, this.chordChannel, this.instrument));
                    this.longChords.remove(chord[i]);
                    continue;
                }
                this.ts.add(new Note(this.nextChordPosition, chord[i], vel, this.chordChannel, this.instrument));
                this.longChords.add(chord[i]);
            }
        }
        this.nextChordPosition += nextChord;
    }

    public Note[] getNotes() {
        Note[] n = new Note[this.ts.size()];
        this.ts.toArray(n);
        return n;
    }
}

