/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.bard.player;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.TreeMap;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import net.heberling.clanlord.bard.player.InstrumentParameter;
import net.heberling.clanlord.bard.player.MusicException;
import net.heberling.clanlord.bard.player.MusicQueue;
import net.heberling.clanlord.bard.player.Note;
import net.heberling.clanlord.bard.player.Song;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicPlayer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MusicPlayer.class);
    private static MusicPlayer musicPlayer;
    private final MidiChannel[] channels;
    private final Synthesizer synth = null;
    private final HashSet<String> playerSet = new HashSet();
    private final TreeMap<String, Song> songMap = new TreeMap();
    private boolean running = false;
    private MusicQueue musicQueue;
    private Thread musicThread;
    private boolean useQuickTimeSoundbank = false;

    private MusicPlayer(Synthesizer audioSynthesizer) {
        try {
            Synthesizer synth = audioSynthesizer;
            if (synth == null) {
                synth = MidiSystem.getSynthesizer();
                synth.open();
            }
            LOGGER.debug("Synthesizer: " + synth);
            LOGGER.debug("Default soundbank: " + synth.getDefaultSoundbank());
            File macOsSoundFont = new File("/System/Library/Components/CoreAudio.component/Contents/Resources/gs_instruments.dls");
            if (macOsSoundFont.exists()) {
                LOGGER.debug("Trying to load " + macOsSoundFont);
                try {
                    this.loadSoundbank(synth, new FileInputStream(macOsSoundFont));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.useQuickTimeSoundbank) {
                try {
                    File windowsOsSoundFont = new File(new File(System.getenv().getOrDefault("ProgramFiles", "C:\\Program Files")), "QuickTime/QTSystem/QuickTimeMusicalInstruments.qtx");
                    LOGGER.debug("Checking " + windowsOsSoundFont);
                    if (!windowsOsSoundFont.exists()) {
                        windowsOsSoundFont = new File(new File(System.getenv().getOrDefault("ProgramFiles(X86)", "C:\\Program Files(X86)")), "QuickTime/QTSystem/QuickTimeMusicalInstruments.qtx");
                        LOGGER.debug("Checking " + windowsOsSoundFont);
                    }
                    if (windowsOsSoundFont.exists()) {
                        LOGGER.debug("Trying to load " + windowsOsSoundFont);
                        FileInputStream stream = new FileInputStream(windowsOsSoundFont);
                        if (((InputStream)stream).skip(4096L) != 4096L) {
                            throw new IOException("Could not skip to embedded RIFF/DTS header");
                        }
                        this.loadSoundbank(synth, stream);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.useQuickTimeSoundbank) {
                this.loadSoundbank(synth, this.getClass().getResourceAsStream("/GeneralUser GS v1.471.min.sf2"));
            }
            this.channels = synth.getChannels();
        }
        catch (MidiUnavailableException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadSoundbank(Synthesizer synth, InputStream stream) {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(new BufferedInputStream(stream));
            synth.loadAllInstruments(soundbank);
            this.useQuickTimeSoundbank = true;
        }
        catch (IOException | InvalidMidiDataException e) {
            LOGGER.error("Could not load sound bank: " + e.getMessage(), e);
        }
    }

    public static synchronized MusicPlayer getMusicPlayer() {
        if (musicPlayer == null) {
            musicPlayer = MusicPlayer.create(null);
        }
        return musicPlayer;
    }

    public static synchronized MusicPlayer create(Synthesizer audioSynthesizer) {
        if (musicPlayer != null) {
            throw new IllegalStateException("MusicPlayer was already created");
        }
        musicPlayer = new MusicPlayer(audioSynthesizer);
        return musicPlayer;
    }

    public boolean isUseQuickTimeSoundbank() {
        return this.useQuickTimeSoundbank;
    }

    public Instrument[] getInstruments() {
        return this.synth.getAvailableInstruments();
    }

    public void setInstrument(Instrument instrument) {
        this.channels[0].programChange(instrument.getPatch().getBank(), instrument.getPatch().getProgram());
    }

    public void addNotes(String player, InstrumentParameter instrument, int volume, int tempo, String notes, boolean missingParts) {
        this.addPlayer(player);
        Song s = this.songMap.get(player);
        if (s == null) {
            s = new Song(notes, instrument, volume, tempo, missingParts);
            this.songMap.put(player, s);
        } else {
            s.notes.append(notes);
            s.needsMore = missingParts;
        }
    }

    public boolean isComplete() {
        String[] o;
        for (String value : o = this.playerSet.toArray(new String[0])) {
            Song s = this.songMap.get(value);
            if (s != null && !s.needsMore) continue;
            return false;
        }
        return true;
    }

    public void play() throws MusicException {
        Object[] o = this.songMap.values().toArray();
        MusicQueue queue = new MusicQueue(null, 0, 0);
        for (int i = 0; i < o.length; ++i) {
            Song s = (Song)o[i];
            MusicQueue q = new MusicQueue(s.instrument, i * 2, i * 2 + 1);
            q.parse(s.notes.toString(), i, s.temp, s.volume);
            queue.addAllFromMusicQueue(q);
        }
        this.clear();
        this.playQueue(queue);
    }

    public void playQueue(MusicQueue queue) {
        this.stopAll();
        this.musicThread = new Thread(this);
        this.musicQueue = queue;
        this.running = true;
        this.musicThread.start();
    }

    public void stopAll() {
        this.running = false;
    }

    public void addPlayer(String string) {
        this.playerSet.add(string);
    }

    @Override
    public void run() {
        Note[] notes = this.musicQueue.getNotes();
        int position = 0;
        for (Note note : notes) {
            if (!this.running) break;
            LOGGER.debug("Position: {}", (Object)position);
            long waitUntil = System.currentTimeMillis() + (long)(note.position - position);
            while (System.currentTimeMillis() < waitUntil) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.channels[note.channel].programChange(note.instrument.getMidiInstrument());
            this.channels[note.channel].noteOn(note.note, note.vel);
            position = note.position;
        }
        for (MidiChannel channel : this.channels) {
            channel.allNotesOff();
        }
        this.musicThread = null;
        this.running = false;
    }

    public void clear() {
        this.playerSet.clear();
        this.songMap.clear();
    }

    public boolean isRunning() {
        return this.running;
    }
}

