/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.bard.editor;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import net.heberling.clanlord.bard.editor.MusicPanel;
import net.heberling.clanlord.bard.player.InstrumentParameter;
import net.heberling.clanlord.bard.player.MusicException;
import net.heberling.clanlord.bard.player.MusicPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArindalTuneHelper
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArindalTuneHelper.class);
    private static final int MAX_BAND_SIZE = 3;
    private static final int MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private Action playButton = null;
    private Action playAllButton = null;
    private Action quitButton = null;
    private final MusicPlayer musicPlayer = MusicPlayer.getMusicPlayer();
    private Action cancelButton = null;
    private MusicPanel[] musicPanel = null;
    private JTabbedPane tabbedPane = null;
    private static final String VERSION = ArindalTuneHelper.readVersion();

    public ArindalTuneHelper() {
        this.initialize();
    }

    private static String readVersion() {
        return ArindalTuneHelper.class.getPackage().getImplementationVersion();
    }

    private void initialize() {
        JPanel jcontentpane = new JPanel();
        jcontentpane.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.musicPanel = new MusicPanel[3];
        for (int i = 0; i < this.musicPanel.length; ++i) {
            this.musicPanel[i] = new MusicPanel();
            this.tabbedPane.add("Instrument " + (i + 1), this.musicPanel[i]);
            if (this.musicPlayer.isUseQuickTimeSoundbank()) continue;
            this.musicPanel[i].setMessage("Could not find QuickTime. Instruments will sound slightly different.");
        }
        jcontentpane.add((Component)this.tabbedPane, "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addButton(new Action[]{this.getPlayButton(), this.getPlayAllButton(), this.getCancelButton()});
        builder.addGlue();
        builder.addButton(new Action[]{this.getQuitButton()});
        jcontentpane.add((Component)builder.getPanel(), "South");
        this.setContentPane(jcontentpane);
        this.setTitle("Arindal Bard Tool " + VERSION + " by AtoroGM");
        this.setDefaultCloseOperation(2);
        this.updateKeyBinding();
        this.pack();
    }

    private Action getPlayButton() {
        if (this.playButton == null) {
            this.playButton = new AbstractAction("Play"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(() -> ArindalTuneHelper.this.play(new MusicPanel[]{ArindalTuneHelper.this.musicPanel[ArindalTuneHelper.this.tabbedPane.getSelectedIndex()]})).start();
                }
            };
            this.getRootPane().getActionMap().put(this.playButton, this.playButton);
        }
        return this.playButton;
    }

    private Action getPlayAllButton() {
        if (this.playAllButton == null) {
            this.playAllButton = new AbstractAction("Play All"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(() -> ArindalTuneHelper.this.play(ArindalTuneHelper.this.musicPanel)).start();
                }
            };
            this.getRootPane().getActionMap().put(this.playAllButton, this.playAllButton);
        }
        return this.playAllButton;
    }

    private void updateKeyBinding() {
        if (this.cancelButton.isEnabled()) {
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(32, 128), this.cancelButton);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(32, 192), this.cancelButton);
        } else {
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(32, 128), this.playButton);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(32, 192), this.playAllButton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play(MusicPanel ... musicPanel) {
        try {
            this.playButton.setEnabled(false);
            this.playAllButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            this.updateKeyBinding();
            this.musicPlayer.clear();
            for (int i = 0; i < musicPanel.length; ++i) {
                MusicPanel currentMusicPanel = musicPanel[i];
                currentMusicPanel.setMessage("");
                InstrumentParameter ip = currentMusicPanel.getInstrument();
                int tempo = currentMusicPanel.getTempo();
                int volume = currentMusicPanel.getVolume() * 10;
                this.musicPlayer.addNotes("player_" + i, ip, volume, tempo, currentMusicPanel.getNotes(), false);
            }
            this.musicPlayer.play();
            while (this.musicPlayer.isRunning()) {
                Thread.yield();
            }
        }
        catch (MusicException e1) {
            LOGGER.debug(e1.getPosition() + " " + e1.getError());
            this.tabbedPane.setSelectedComponent(musicPanel[e1.getChannel()]);
            musicPanel[e1.getChannel()].setNoteCursor(e1.getPosition());
            musicPanel[e1.getChannel()].setMessage(e1.getMessage());
            this.musicPlayer.stopAll();
            this.musicPlayer.clear();
        }
        finally {
            this.cancelButton.setEnabled(false);
            this.playButton.setEnabled(true);
            this.playAllButton.setEnabled(true);
            this.updateKeyBinding();
        }
    }

    private Action getQuitButton() {
        if (this.quitButton == null) {
            this.quitButton = new AbstractAction("Quit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            };
        }
        return this.quitButton;
    }

    private Action getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArindalTuneHelper.this.musicPlayer.stopAll();
                    ArindalTuneHelper.this.musicPlayer.clear();
                }
            };
            this.cancelButton.setEnabled(false);
            this.getRootPane().getActionMap().put(this.cancelButton, this.cancelButton);
        }
        return this.cancelButton;
    }

    public static void main(String[] args) {
        new ArindalTuneHelper().setVisible(true);
    }
}

