/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.bard.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.tisoft.rsyntaxtextarea.parser.antlr.AntlrParserBase;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.heberling.clanlord.bard.editor.MusicTokenMaker;
import net.heberling.clanlord.bard.parser.InstrumentParameter;
import net.heberling.clanlord.bard.parser.MusicLexer;
import net.heberling.clanlord.bard.parser.MusicParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenStream;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.RTextScrollPane;

public class MusicPanel
extends JPanel {
    private JComboBox<InstrumentParameter> instrumentComboBox = null;
    private JSlider tempoSlider = null;
    private JSlider volumeSlider = null;
    private RSyntaxTextArea notesTextArea = null;
    private JLabel messageLabel = null;

    public MusicPanel() {
        this.initialize();
    }

    private void initialize() {
        InstrumentParameter[] instrumentParameters;
        FormLayout formLayout = new FormLayout("3dlu,right:default,3dlu,default:grow,3dlu", "3dlu,pref,3dlu,pref,3dlu,pref,3dlu,top:100px:grow,3dlu,pref,3dlu");
        PanelBuilder builder = new PanelBuilder(formLayout, this);
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Instrument:", cc.xy(2, 2));
        builder.addLabel("Tempo:", cc.xy(2, 4));
        builder.addLabel("Volume:", cc.xy(2, 6));
        builder.addLabel("Notes:", cc.xy(2, 8));
        this.instrumentComboBox = new JComboBox();
        DefaultComboBoxModel<InstrumentParameter> instModel = new DefaultComboBoxModel<InstrumentParameter>();
        for (InstrumentParameter instrumentParameter : instrumentParameters = InstrumentParameter.getAllInstrumentParameters()) {
            instModel.addElement(instrumentParameter);
        }
        this.instrumentComboBox.setModel(instModel);
        builder.add(this.instrumentComboBox, cc.xy(4, 2));
        this.tempoSlider = new JSlider();
        this.tempoSlider.setMinimum(60);
        this.tempoSlider.setMaximum(180);
        this.tempoSlider.setValue(120);
        this.tempoSlider.setPaintLabels(true);
        this.tempoSlider.setPaintTicks(true);
        this.tempoSlider.setMajorTickSpacing(20);
        this.tempoSlider.setMinorTickSpacing(10);
        builder.add((Component)this.tempoSlider, cc.xy(4, 4));
        this.volumeSlider = new JSlider();
        this.volumeSlider.setMaximum(10);
        this.volumeSlider.setMinorTickSpacing(1);
        this.volumeSlider.setPaintLabels(true);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setMajorTickSpacing(2);
        this.volumeSlider.setMinimum(0);
        builder.add((Component)this.volumeSlider, cc.xy(4, 6));
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/clmusic", MusicTokenMaker.class.getName(), MusicTokenMaker.class.getClassLoader());
        this.notesTextArea = new RSyntaxTextArea();
        this.notesTextArea.setSyntaxEditingStyle("text/clmusic");
        this.notesTextArea.addParser(new AntlrParserBase<MusicLexer, MusicParser>(){

            @Override
            protected MusicLexer createLexer(CharStream charStream) {
                return new MusicLexer(charStream);
            }

            @Override
            protected MusicParser createParser(TokenStream tokenStream) {
                return new MusicParser(tokenStream);
            }

            @Override
            protected void parse(MusicParser musicParser) {
                musicParser.song();
            }

            @Override
            public ParseResult parse(RSyntaxDocument doc, String style) {
                ParseResult parseResult = super.parse(doc, style);
                MusicPanel.this.messageLabel.setText(null);
                parseResult.getNotices().stream().map(ParserNotice::getMessage).findFirst().ifPresent(MusicPanel.this.messageLabel::setText);
                return parseResult;
            }
        });
        RTextScrollPane scrollPane = new RTextScrollPane(this.notesTextArea);
        builder.add((Component)scrollPane, cc.xy(4, 8, "fill,fill"));
        this.messageLabel = new JLabel("OK");
        builder.add((Component)this.messageLabel, cc.xyw(2, 10, 3, "fill,default"));
    }

    public int getVolume() {
        return this.volumeSlider.getValue();
    }

    public int getTempo() {
        return this.tempoSlider.getValue();
    }

    public InstrumentParameter getInstrument() {
        return (InstrumentParameter)this.instrumentComboBox.getSelectedItem();
    }

    public String getNotes() {
        return this.notesTextArea.getText();
    }

    public void setNoteCursor(int position) {
        if (position >= 0) {
            this.notesTextArea.requestFocusInWindow();
            this.notesTextArea.setCaretPosition(position);
            this.notesTextArea.setSelectionStart(position);
            this.notesTextArea.setSelectionEnd(position);
        }
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }
}

