/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.bard.parser;

import java.io.DataInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentParameter.class);
    public static final int INSTRUMENT_COUNT = 17;
    private static final InstrumentParameter[] instrumentParameters = new InstrumentParameter[18];
    public static final int FLAGS_NO_CHORDS = 1;
    public static final int FLAGS_NO_MELODY = 2;
    public static final int FLAGS_LONG_CHORD = 4;
    public static final int FLAGS_CUSTOM = 128;
    public static final int DEFAULT_POLYPHONY = 6;
    public static final int BITS_PER_LONG = 32;
    private final int midiInstrument;
    private final int mOctaveOffset;
    private int polyphony = 4;
    private int flags = 8;
    private final short chordVelocity;
    private final short melodyVelocity;
    private int[] mRestrictions;
    private final String name;

    private static String readStr31(DataInputStream dis) throws IOException {
        int lenght = dis.readByte() & 0xFF;
        byte[] b = new byte[lenght];
        dis.read(b);
        dis.skipBytes(31 - lenght);
        return new String(b, "x-MacRoman");
    }

    private InstrumentParameter(String name, int midiInstrument, short mOctaveOffset, int polyphony, int flags, short chordVelocity, short melodyVelocity, int[] mRestrictions) {
        this.name = name;
        this.midiInstrument = midiInstrument;
        this.mOctaveOffset = mOctaveOffset + 1;
        this.polyphony = polyphony;
        this.flags = flags;
        this.chordVelocity = chordVelocity;
        this.melodyVelocity = melodyVelocity;
        this.mRestrictions = mRestrictions;
    }

    public static InstrumentParameter getInstrument(int instrument) {
        if (instrument >= 0 && instrument <= 17) {
            return instrumentParameters[instrument];
        }
        return null;
    }

    public static InstrumentParameter[] getAllInstrumentParameters() {
        return instrumentParameters;
    }

    int noteToOffset(int inNote) {
        return inNote - (48 + this.mOctaveOffset * 12);
    }

    int offsetToNote(int inOffset) {
        return 48 + this.mOctaveOffset * 12 + inOffset;
    }

    boolean hasMelody() {
        return (this.flags & 2) == 0;
    }

    boolean hasChords() {
        return (this.flags & 1) == 0;
    }

    int getPolyphony() {
        return this.hasChords() ? this.polyphony : 0;
    }

    boolean isNoteRestricted(int inNote) {
        int off = this.noteToOffset(inNote);
        return this.isOffsetRestricted(off);
    }

    private boolean isOffsetRestricted(int inOffset) {
        return (this.mRestrictions[inOffset / 32] >> 31 - inOffset % 32 & 1) != 0;
    }

    public boolean isLongChordsSupported() {
        return (this.flags & 4) > 0;
    }

    public int getMidiInstrument() {
        return this.midiInstrument;
    }

    public short getChordVelocity() {
        return this.chordVelocity;
    }

    public short getMelodyVelocity() {
        return this.melodyVelocity;
    }

    public String toString() {
        return this.name;
    }

    static {
        try {
            DataInputStream dis = new DataInputStream(InstrumentParameter.class.getResourceAsStream("/CCLInstrument"));
            int i = 0;
            do {
                int synthType = dis.readInt();
                String synthName = InstrumentParameter.readStr31(dis);
                String instrName = InstrumentParameter.readStr31(dis);
                int instrNumber = dis.readInt();
                int gmNumber = dis.readInt();
                short octaveOffset = dis.readShort();
                byte unusedPolyphony = dis.readByte();
                byte flags = dis.readByte();
                int unused = unusedPolyphony >> 4 & 0xF;
                int polyphony = unusedPolyphony & 0xF;
                short chordVelocity = dis.readShort();
                short melodyVelocity = dis.readShort();
                int[] restrictions = new int[2];
                for (int j = 0; j < restrictions.length; ++j) {
                    restrictions[j] = dis.readInt();
                }
                String cclName = InstrumentParameter.readStr31(dis);
                LOGGER.debug("CCLInstrument number:" + i);
                LOGGER.debug("Synthesizer type: " + synthType);
                LOGGER.debug("Synthesizer name: " + synthName);
                LOGGER.debug("Instrument Name: " + instrName);
                LOGGER.debug("Instrument Number: " + instrNumber);
                LOGGER.debug("GM Number " + gmNumber);
                LOGGER.debug("Octave offset :" + octaveOffset);
                LOGGER.debug("unused " + unused);
                LOGGER.debug("Polyphony " + polyphony);
                LOGGER.debug("Flags: " + flags);
                LOGGER.debug("Chord Velocity " + chordVelocity);
                LOGGER.debug("Melody Velovity: " + melodyVelocity);
                LOGGER.debug("CCLName: " + cclName);
                InstrumentParameter.instrumentParameters[i] = new InstrumentParameter(cclName, gmNumber - 1, octaveOffset, polyphony, flags, chordVelocity, melodyVelocity, restrictions);
            } while (++i <= 17);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

