/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.clanlord.bard.player.visitor;

import java.util.List;
import net.heberling.clanlord.bard.parser.MusicParser;
import net.heberling.clanlord.bard.player.InstrumentParameter;
import net.heberling.clanlord.bard.player.MusicConstants;
import net.heberling.clanlord.bard.player.MusicException;
import net.heberling.clanlord.bard.player.MusicQueue;
import net.heberling.clanlord.bard.player.visitor.Chord;
import net.heberling.clanlord.bard.player.visitor.Note;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicVisitor
implements MusicConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(MusicVisitor.class);
    private static final int DURATION_BLACK = 2;
    private static final int DURATION_WHITE = 4;
    private static final short[] MIDI_NOTES = new short[]{69, 71, 60, 62, 64, 65, 67};
    private final MusicQueue musicQueue;
    private int octave;
    private float pauseLength;
    private long noteLength;
    private int melodyVelocity;
    private int melodyVolume;
    private int tempo;
    private int velocity;
    private int chordVelocity;
    private final InstrumentParameter instrument;
    private Chord chord;

    private void setTempo(int inTempo) {
        LOGGER.debug("Tempo: {}", (Object)inTempo);
        this.tempo = inTempo;
        if (this.tempo > 180) {
            this.tempo = 180;
        }
        if (this.tempo < 60) {
            this.tempo = 180;
        }
        this.pauseLength = 1000.0f / ((float)this.tempo / 60.0f) / 4.0f;
        LOGGER.debug("Pause lenght: {}", (Object)Float.valueOf(this.pauseLength));
        this.noteLength = (long)this.pauseLength * 90L / 100L;
    }

    private void setVolume(int inVelocity) {
        this.velocity = inVelocity;
        this.chordVelocity = this.velocity * this.instrument.getChordVelocity() / 100;
        this.melodyVelocity = this.velocity * this.instrument.getMelodyVelocity() / 100;
    }

    public MusicVisitor(MusicQueue musicQueue, int tempo, int volume) {
        this.musicQueue = musicQueue;
        this.instrument = musicQueue.getInstrument();
        this.setTempo((int)(1.2f * (float)tempo));
        this.setVolume((int)(1.0f * (float)volume));
        this.melodyVolume = 10;
    }

    private Note getNote(char c, int octave) {
        Note mNote = null;
        if (c >= 'a' && c <= 'g') {
            mNote = new Note(MIDI_NOTES[c - 97] + octave * 12, 2);
        } else if (c >= 'A' && c <= 'G') {
            mNote = new Note(MIDI_NOTES[c - 65] + octave * 12, 4);
        } else {
            return null;
        }
        mNote.tone -= 60;
        return mNote;
    }

    int getNoteDuration(boolean inLinked, int inDuration) {
        return (int)(inLinked ? (float)inDuration * this.pauseLength : (inDuration > 1 ? (float)(inDuration - 1) * this.pauseLength + (float)this.noteLength : (float)this.noteLength));
    }

    private void modifyNote(Note note, MusicParser.NoteModifierContext modifierTree) {
        if (modifierTree.duration() != null) {
            note.duration = Integer.parseInt(modifierTree.duration().getText());
        }
        if (modifierTree.UNDERSCORE() != null) {
            note.linked = true;
        }
        if (modifierTree.PERIOD() != null) {
            --note.tone;
        }
        if (modifierTree.HASH() != null) {
            ++note.tone;
        }
    }

    public void visit(ParseTree node) throws MusicException {
        if (node == null) {
            return;
        }
        if (node instanceof MusicParser.NoteContext) {
            this.handleNote((MusicParser.NoteContext)node);
        } else if (node instanceof MusicParser.TempoContext) {
            this.handleTempo((MusicParser.TempoContext)node);
        } else if (node instanceof MusicParser.OctaveContext) {
            this.handleOctave((MusicParser.OctaveContext)node);
        } else if (node instanceof MusicParser.PauseContext) {
            this.handlePause((MusicParser.PauseContext)node);
        } else if (node instanceof MusicParser.VolumeContext) {
            this.handleVolume((MusicParser.VolumeContext)node);
        } else if (node instanceof MusicParser.RepeatContext) {
            this.handleLoop((MusicParser.RepeatContext)node);
        } else if (node instanceof MusicParser.ChordContext) {
            this.handleChord((MusicParser.ChordContext)node);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.visit(node.getChild(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleChord(MusicParser.ChordContext node) throws MusicException {
        this.chord = new Chord();
        this.chord.volume = 10;
        this.chord.duration = 4;
        if (node.chordduration() != null) {
            if (node.chordduration().DOLLAR() != null) {
                if (!this.instrument.isLongChordsSupported()) throw new MusicException(this.musicQueue.getMelodyChannel(), "no long chords", node.getStart().getCharPositionInLine());
                this.chord.duration = 0;
            } else {
                this.chord.duration = Integer.parseInt(node.chordduration().INTEGER().getText());
            }
        }
        this.visit((ParseTree)node.chordelements());
        this.musicQueue.addChord(this.chord.chord, this.chord.lenght, this.chordVelocity * (this.chord.volume * 10) / 100, this.getNoteDuration(this.chord.linked, this.chord.duration), (int)((float)this.chord.duration * this.pauseLength));
        this.chord = null;
    }

    private void handleLoop(MusicParser.RepeatContext node) throws MusicException {
        int count = 2;
        if (node.INTEGER() != null) {
            count = Integer.parseInt(node.INTEGER().getText());
        }
        MusicParser.RepeatcontentContext content = node.repeatcontent();
        List endings = node.repeatendingnumber();
        MusicParser.RepeatendingdefaultContext defaultending = node.repeatendingdefault();
        for (int i = 1; i <= count; ++i) {
            this.visit((ParseTree)content);
            int currentCount = i;
            MusicParser.RepeatcontentContext context = endings.stream().filter(repeatendingnumberContext -> Integer.parseInt(repeatendingnumberContext.INTEGER().getText()) == currentCount).map(MusicParser.RepeatendingnumberContext::repeatcontent).findFirst().orElse(null);
            if (context != null) {
                this.visit((ParseTree)context);
                continue;
            }
            if (defaultending == null) continue;
            this.visit((ParseTree)defaultending.repeatcontent());
        }
    }

    private void handleVolume(MusicParser.VolumeContext node) {
        int vol;
        int n = vol = this.chord != null ? this.chord.volume : this.melodyVolume;
        if (node.volumeabsolut() != null) {
            vol = node.volumeabsolut().INTEGER() == null ? 10 : Integer.parseInt(node.volumeabsolut().INTEGER().getText());
        } else if (node.volumeminus() != null) {
            vol -= node.volumeminus().INTEGER() == null ? 1 : Integer.parseInt(node.volumeminus().INTEGER().getText());
        } else if (node.volumeplus() != null) {
            vol += node.volumeplus().INTEGER() == null ? 1 : Integer.parseInt(node.volumeplus().INTEGER().getText());
        }
        if (vol < 1) {
            vol = 1;
        }
        if (vol > 10) {
            vol = 10;
        }
        if (this.chord != null) {
            this.chord.volume = vol;
        } else {
            this.melodyVolume = vol;
        }
    }

    private void handlePause(MusicParser.PauseContext node) {
        int duration = 2;
        if (node.duration() != null) {
            duration = Integer.parseInt(node.duration().getText());
        }
        this.musicQueue.addPause((int)((float)duration * this.pauseLength));
    }

    private void handleOctave(MusicParser.OctaveContext node) {
        if (node.octavelow() != null) {
            this.octave = -1;
        } else if (node.octavemedium() != null) {
            this.octave = 0;
        } else if (node.octavehigh() != null) {
            this.octave = 1;
        } else if (node.octaveminus() != null) {
            --this.octave;
        } else if (node.octaveplus() != null) {
            ++this.octave;
        }
        if (this.octave > 1) {
            this.octave = 1;
        } else if (this.octave < -1) {
            this.octave = -1;
        }
    }

    private void handleTempo(MusicParser.TempoContext node) {
        if (node.tempoabsolute() != null) {
            this.setTempo(node.tempoabsolute().INTEGER() == null ? 120 : Integer.parseInt(node.tempoabsolute().INTEGER().getText()));
        } else if (node.tempominus() != null) {
            this.setTempo(this.tempo - (node.tempominus().INTEGER() == null ? 10 : Integer.parseInt(node.tempominus().INTEGER().getText())));
        } else if (node.tempoplus() != null) {
            this.setTempo(this.tempo + (node.tempoplus().INTEGER() == null ? 10 : Integer.parseInt(node.tempoplus().INTEGER().getText())));
        }
    }

    private void handleNote(MusicParser.NoteContext node) {
        Note note = this.getNote(node.NOTELETTER().getText().charAt(0), this.octave);
        this.modifyNote(note, node.noteModifier());
        if (this.chord != null) {
            this.chord.addNote(note);
        } else {
            this.musicQueue.addNote(note.tone, this.melodyVelocity * (this.melodyVolume * 10) / 100, this.getNoteDuration(note.linked, note.duration), (int)((float)note.duration * this.pauseLength));
        }
    }
}

