/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.cli;

import com.owlike.genson.stream.JsonType;
import com.owlike.genson.stream.ObjectWriter;
import java.nio.charset.StandardCharsets;

public class UTF8StringObjectWriter
implements ObjectWriter {
    private final ObjectWriter delegate;
    private String utf8EncodedByteArrayName;

    public UTF8StringObjectWriter(ObjectWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public ObjectWriter beginArray() {
        return this.delegate.beginArray();
    }

    @Override
    public ObjectWriter endArray() {
        return this.delegate.endArray();
    }

    @Override
    public ObjectWriter beginObject() {
        return this.delegate.beginObject();
    }

    @Override
    public ObjectWriter endObject() {
        return this.delegate.endObject();
    }

    @Override
    public ObjectWriter writeName(String name) {
        return this.delegate.writeName(name);
    }

    @Override
    public ObjectWriter writeEscapedName(char[] name) {
        String nameString = String.valueOf(name);
        if (nameString.equals("content") || nameString.equals("brandName") || nameString.equals("colorName") || nameString.equals("modelName") || nameString.equals("sender") || nameString.equals("title") || nameString.equals("errorMessage") || nameString.equals("rvcReqType") || nameString.equals("paramValue")) {
            this.utf8EncodedByteArrayName = "@" + nameString + "UTF8";
        }
        return this.delegate.writeEscapedName(name);
    }

    @Override
    public ObjectWriter writeValue(int value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeValue(double value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeValue(long value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeValue(short value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeValue(float value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeValue(boolean value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeBoolean(Boolean value) {
        return this.delegate.writeBoolean(value);
    }

    @Override
    public ObjectWriter writeValue(Number value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeNumber(Number value) {
        return this.delegate.writeNumber(value);
    }

    @Override
    public ObjectWriter writeValue(String value) {
        return this.delegate.writeValue(value);
    }

    @Override
    public ObjectWriter writeString(String value) {
        return this.delegate.writeString(value);
    }

    @Override
    public ObjectWriter writeValue(byte[] value) {
        ObjectWriter writer = this.delegate.writeValue(value);
        if (this.utf8EncodedByteArrayName != null) {
            writer.writeEscapedName(this.utf8EncodedByteArrayName.toCharArray());
            writer.writeString(new String(value, StandardCharsets.UTF_8));
            this.utf8EncodedByteArrayName = null;
        }
        return writer;
    }

    @Override
    public ObjectWriter writeBytes(byte[] value) {
        return this.delegate.writeBytes(value);
    }

    @Override
    public ObjectWriter writeUnsafeValue(String value) {
        return this.delegate.writeUnsafeValue(value);
    }

    @Override
    public ObjectWriter writeNull() {
        this.utf8EncodedByteArrayName = null;
        return this.delegate.writeNull();
    }

    @Override
    public ObjectWriter beginNextObjectMetadata() {
        return this.delegate.beginNextObjectMetadata();
    }

    @Override
    public ObjectWriter writeMetadata(String name, String value) {
        return this.delegate.writeMetadata(name, value);
    }

    @Override
    public ObjectWriter writeBoolean(String name, Boolean value) {
        return this.delegate.writeBoolean(name, value);
    }

    @Override
    public ObjectWriter writeNumber(String name, Number value) {
        return this.delegate.writeNumber(name, value);
    }

    @Override
    public ObjectWriter writeString(String name, String value) {
        return this.delegate.writeString(name, value);
    }

    @Override
    public ObjectWriter writeBytes(String name, byte[] value) {
        return this.delegate.writeBytes(name, value);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public JsonType enclosingType() {
        return this.delegate.enclosingType();
    }
}

