/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.cli;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Random;
import net.heberling.ismart.asn1.AbstractMessage;
import net.heberling.ismart.asn1.AbstractMessageCoder;
import net.heberling.ismart.asn1.Anonymizer;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherBody;
import net.heberling.ismart.asn1.v1_1.Message;
import net.heberling.ismart.asn1.v1_1.MessageCounter;
import net.heberling.ismart.asn1.v1_1.entity.MP_UserLoggingInReq;
import net.heberling.ismart.asn1.v1_1.entity.MP_UserLoggingInResp;
import net.heberling.ismart.asn1.v1_1.entity.VinInfo;
import net.heberling.ismart.asn1.v3_0.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v3_0.MessageCoder;
import net.heberling.ismart.asn1.v3_0.entity.OTA_ChrgMangDataResp;
import net.heberling.ismart.cli.UTF8StringObjectWriter;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.bn.annotations.ASN1Enum;
import org.bn.annotations.ASN1Sequence;
import org.bn.coders.IASN1PreparedElement;

public class GetData {
    public static void main(String[] args) throws IOException {
        Message loginRequestMessage = new Message(new net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader(), new MP_DispatcherBody(), (IASN1PreparedElement)new MP_UserLoggingInReq());
        MessageCounter messageCounter = new MessageCounter();
        messageCounter.setDownlinkCounter(Integer.valueOf(0));
        messageCounter.setUplinkCounter(Integer.valueOf(1));
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setMessageCounter(messageCounter);
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setMessageID(Integer.valueOf(1));
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setIccID("12345678901234567890");
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setSimInfo("1234567890987654321");
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setEventCreationTime(Long.valueOf(Instant.now().getEpochSecond()));
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setApplicationID("501");
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setApplicationDataProtocolVersion(Integer.valueOf(513));
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setTestFlag(Integer.valueOf(2));
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setUid("0000000000000000000000000000000000000000000000000#".substring(args[0].length()) + args[0]);
        ((MP_UserLoggingInReq)loginRequestMessage.getApplicationData()).setPassword(args[1]);
        String loginRequest = new net.heberling.ismart.asn1.v1_1.MessageCoder(MP_UserLoggingInReq.class).encodeRequest(loginRequestMessage);
        System.out.println(GetData.toJSON(GetData.anonymized(new net.heberling.ismart.asn1.v1_1.MessageCoder(MP_UserLoggingInReq.class), loginRequestMessage)));
        String loginResponse = GetData.sendRequest(loginRequest, "https://tap-eu.soimt.com/TAP.Web/ota.mp");
        Message loginResponseMessage = new net.heberling.ismart.asn1.v1_1.MessageCoder(MP_UserLoggingInResp.class).decodeResponse(loginResponse);
        System.out.println(GetData.toJSON(GetData.anonymized(new net.heberling.ismart.asn1.v1_1.MessageCoder(MP_UserLoggingInResp.class), loginResponseMessage)));
        for (VinInfo vin : ((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getVinList()) {
            net.heberling.ismart.asn1.v3_0.Message chargingStatusMessage = new net.heberling.ismart.asn1.v3_0.Message(new MP_DispatcherHeader(), new byte[16], new net.heberling.ismart.asn1.v3_0.MP_DispatcherBody(), null);
            GetData.fillReserved((net.heberling.ismart.asn1.v3_0.Message<IASN1PreparedElement>)chargingStatusMessage);
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setApplicationID("516");
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setTestFlag(Integer.valueOf(2));
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setVin(vin.getVin());
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setUid(((MP_DispatcherBody)loginResponseMessage.getBody()).getUid());
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setToken(((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getToken());
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setMessageID(Integer.valueOf(5));
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventCreationTime(Integer.valueOf((int)Instant.now().getEpochSecond()));
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setApplicationDataProtocolVersion(Integer.valueOf(768));
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventID(Integer.valueOf(0));
            String chargingStatusRequestMessage = new MessageCoder(IASN1PreparedElement.class).encodeRequest(chargingStatusMessage);
            System.out.println(GetData.toJSON(GetData.anonymized(new MessageCoder(IASN1PreparedElement.class), chargingStatusMessage)));
            String chargingStatusResponse = GetData.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv30");
            net.heberling.ismart.asn1.v3_0.Message chargingStatusResponseMessage = new MessageCoder(OTA_ChrgMangDataResp.class).decodeResponse(chargingStatusResponse);
            System.out.println(GetData.toJSON(GetData.anonymized(new MessageCoder(OTA_ChrgMangDataResp.class), chargingStatusResponseMessage)));
            ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventID(((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getEventID());
            while (chargingStatusResponseMessage.getApplicationData() == null) {
                GetData.fillReserved((net.heberling.ismart.asn1.v3_0.Message<IASN1PreparedElement>)chargingStatusMessage);
                System.out.println(GetData.toJSON(GetData.anonymized(new MessageCoder(IASN1PreparedElement.class), chargingStatusMessage)));
                chargingStatusRequestMessage = new MessageCoder(IASN1PreparedElement.class).encodeRequest(chargingStatusMessage);
                chargingStatusResponse = GetData.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv30");
                chargingStatusResponseMessage = new MessageCoder(OTA_ChrgMangDataResp.class).decodeResponse(chargingStatusResponse);
                System.out.println(GetData.toJSON(GetData.anonymized(new MessageCoder(OTA_ChrgMangDataResp.class), chargingStatusResponseMessage)));
            }
        }
    }

    private static <H extends IASN1PreparedElement, B extends IASN1PreparedElement, E extends IASN1PreparedElement, M extends AbstractMessage<H, B, E>> M anonymized(AbstractMessageCoder<H, B, E, M> coder, M message) {
        AbstractMessage messageCopy = coder.decodeResponse(coder.encodeRequest(message));
        Anonymizer.anonymize((AbstractMessage)messageCopy);
        return (M)messageCopy;
    }

    private static void fillReserved(net.heberling.ismart.asn1.v3_0.Message<IASN1PreparedElement> chargingStatusMessage) {
        System.arraycopy((new Random(System.currentTimeMillis()).nextLong() + "1111111111111111").getBytes(), 0, chargingStatusMessage.getReserved(), 0, 16);
    }

    private static String sendRequest(String request, String endpoint) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(endpoint);
            httppost.setEntity((HttpEntity)new StringEntity(request, ContentType.TEXT_HTML));
            HttpClientResponseHandler responseHandler = response -> {
                int status = response.getCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    try {
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException((Throwable)ex);
                    }
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            String string = (String)httpclient.execute((ClassicHttpRequest)httppost, responseHandler);
            return string;
        }
    }

    public static <H extends IASN1PreparedElement, B extends IASN1PreparedElement, E extends IASN1PreparedElement, M extends AbstractMessage<H, B, E>> String toJSON(M message) {
        ChainedFactory chain = new ChainedFactory(){

            protected Converter<?> create(Type type, Genson genson, final Converter<?> nextConverter) {
                return new Converter<Object>(){

                    public void serialize(Object object, ObjectWriter writer, Context ctx) throws Exception {
                        if (object != null) {
                            writer.beginNextObjectMetadata();
                            if (object.getClass().isAnnotationPresent(ASN1Enum.class)) {
                                writer.writeMetadata("ASN1Type", object.getClass().getAnnotation(ASN1Enum.class).name());
                            } else if (object.getClass().isAnnotationPresent(ASN1Sequence.class)) {
                                writer.writeMetadata("ASN1Type", object.getClass().getAnnotation(ASN1Sequence.class).name());
                            }
                        }
                        Converter n = nextConverter;
                        if (!(writer instanceof UTF8StringObjectWriter)) {
                            writer = new UTF8StringObjectWriter(writer);
                        }
                        n.serialize(object, writer, ctx);
                    }

                    public Object deserialize(ObjectReader reader, Context ctx) throws Exception {
                        return nextConverter.deserialize(reader, ctx);
                    }
                };
            }
        };
        chain.withNext((Factory)new ChainedFactory(){

            protected Converter<?> create(Type type, Genson genson, Converter<?> converter) {
                final Class clazz = TypeUtil.getRawClass((Type)type);
                if (clazz.isAnnotationPresent(ASN1Enum.class)) {
                    return new Converter<Object>(){

                        public void serialize(Object o, ObjectWriter objectWriter, Context context) throws Exception {
                            Method getValue = clazz.getMethod("getValue", new Class[0]);
                            Object value = getValue.invoke(o, new Object[0]);
                            if (value == null) {
                                objectWriter.writeNull();
                            } else {
                                objectWriter.writeString(String.valueOf(value));
                            }
                        }

                        public Object deserialize(ObjectReader objectReader, Context context) throws Exception {
                            throw new UnsupportedOperationException("not implemented yet");
                        }
                    };
                }
                return converter;
            }
        });
        return new GensonBuilder().useIndentation(true).useRuntimeType(true).exclude("preparedData").withConverterFactory(chain).create().serialize(message);
    }
}

