/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.message.TokenParser;

public class AuthChallengeParser {
    public static final AuthChallengeParser INSTANCE = new AuthChallengeParser();
    private final TokenParser tokenParser = TokenParser.INSTANCE;
    private static final char BLANK = ' ';
    private static final char COMMA_CHAR = ',';
    private static final char EQUAL_CHAR = '=';
    private static final BitSet TERMINATORS = TokenParser.INIT_BITSET(32, 61, 44);
    private static final BitSet DELIMITER = TokenParser.INIT_BITSET(44);

    NameValuePair parseTokenOrParameter(CharSequence buffer, ParserCursor cursor) {
        this.tokenParser.skipWhiteSpace(buffer, cursor);
        String token = this.tokenParser.parseToken(buffer, cursor, TERMINATORS);
        if (!cursor.atEnd()) {
            if (buffer.charAt(cursor.getPos()) == ' ') {
                this.tokenParser.skipWhiteSpace(buffer, cursor);
            }
            if (!cursor.atEnd() && buffer.charAt(cursor.getPos()) == '=') {
                cursor.updatePos(cursor.getPos() + 1);
                String value = this.tokenParser.parseValue(buffer, cursor, DELIMITER);
                return new BasicNameValuePair(token, value);
            }
        }
        return new BasicNameValuePair(token, null);
    }

    public List<AuthChallenge> parse(ChallengeType challengeType, CharSequence buffer, ParserCursor cursor) throws ParseException {
        ArrayList<AuthChallenge> list = new ArrayList<AuthChallenge>();
        String schemeName = null;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair tokenOrParameter = this.parseTokenOrParameter(buffer, cursor);
            if (tokenOrParameter.getValue() == null && !cursor.atEnd() && buffer.charAt(cursor.getPos()) != ',') {
                if (schemeName != null) {
                    if (params.isEmpty()) {
                        throw new ParseException("Malformed auth challenge");
                    }
                    list.add(AuthChallengeParser.createAuthChallenge(challengeType, schemeName, params));
                    params.clear();
                }
                schemeName = tokenOrParameter.getName();
            } else {
                params.add(tokenOrParameter);
                if (!cursor.atEnd() && buffer.charAt(cursor.getPos()) != ',') {
                    schemeName = null;
                }
            }
            if (cursor.atEnd() || buffer.charAt(cursor.getPos()) != ',') continue;
            cursor.updatePos(cursor.getPos() + 1);
        }
        list.add(AuthChallengeParser.createAuthChallenge(challengeType, schemeName, params));
        return list;
    }

    private static AuthChallenge createAuthChallenge(ChallengeType challengeType, String schemeName, List<NameValuePair> params) throws ParseException {
        NameValuePair nvp;
        if (schemeName != null) {
            NameValuePair nvp2;
            if (params.size() == 1 && (nvp2 = params.get(0)).getValue() == null) {
                return new AuthChallenge(challengeType, schemeName, nvp2.getName(), null);
            }
            return new AuthChallenge(challengeType, schemeName, null, params.size() > 0 ? params : null);
        }
        if (params.size() == 1 && (nvp = params.get(0)).getValue() == null) {
            return new AuthChallenge(challengeType, nvp.getName(), null, null);
        }
        throw new ParseException("Malformed auth challenge");
    }
}

