/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.gateway;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Random;
import net.heberling.ismart.asn1.AbstractMessage;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherBody;
import net.heberling.ismart.asn1.v1_1.Message;
import net.heberling.ismart.asn1.v1_1.MessageCounter;
import net.heberling.ismart.asn1.v1_1.entity.MP_UserLoggingInReq;
import net.heberling.ismart.asn1.v1_1.entity.MP_UserLoggingInResp;
import net.heberling.ismart.asn1.v3_0.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v3_0.MessageCoder;
import net.heberling.ismart.asn1.v3_0.entity.OTA_ChrgMangDataResp;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.bn.annotations.ASN1Enum;
import org.bn.coders.IASN1PreparedElement;

public class GetData {
    public static String[] startResponse(String[] args) throws IOException {
        String[] jsonOuput = new String[4];
        Message<MP_UserLoggingInReq> loginRequestMessage = new Message<MP_UserLoggingInReq>(new net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader(), new MP_DispatcherBody(), new MP_UserLoggingInReq());
        MessageCounter messageCounter = new MessageCounter();
        messageCounter.setDownlinkCounter(0);
        messageCounter.setUplinkCounter(1);
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setMessageCounter(messageCounter);
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setMessageID(1);
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setIccID("12345678901234567890");
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setSimInfo("1234567890987654321");
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setEventCreationTime(Instant.now().getEpochSecond());
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setApplicationID("501");
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setApplicationDataProtocolVersion(513);
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setTestFlag(2);
        ((MP_DispatcherBody)loginRequestMessage.getBody()).setUid("0000000000000000000000000000000000000000000000000#".substring(args[0].length()) + args[0]);
        ((MP_UserLoggingInReq)loginRequestMessage.getApplicationData()).setPassword(args[1]);
        ((MP_UserLoggingInReq)loginRequestMessage.getApplicationData()).setDeviceId("cqSHOMG1SmK4k-fzAeK6hr:APA91bGtGihOG5SEQ9hPx3Dtr9o9mQguNiKZrQzboa-1C_UBlRZYdFcMmdfLvh9Q_xA8A0dGFIjkMhZbdIXOYnKfHCeWafAfLXOrxBS3N18T4Slr-x9qpV6FHLMhE9s7I6s89k9lU7DD###europecar");
        String loginRequest = new net.heberling.ismart.asn1.v1_1.MessageCoder<MP_UserLoggingInReq>(MP_UserLoggingInReq.class).encodeRequest(loginRequestMessage);
        jsonOuput[0] = GetData.toJSON(loginRequestMessage);
        System.out.println("Sending login request...");
        String loginResponse = GetData.sendRequest(loginRequest, "https://tap-eu.soimt.com/TAP.Web/ota.mp");
        AbstractMessage loginResponseMessage = new net.heberling.ismart.asn1.v1_1.MessageCoder<MP_UserLoggingInResp>(MP_UserLoggingInResp.class).decodeResponse(loginResponse);
        net.heberling.ismart.asn1.v3_0.Message<Object> chargingStatusMessage = new net.heberling.ismart.asn1.v3_0.Message<Object>(new MP_DispatcherHeader(), new byte[16], new net.heberling.ismart.asn1.v3_0.MP_DispatcherBody(), null);
        GetData.fillReserved(chargingStatusMessage);
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setApplicationID("516");
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setTestFlag(2);
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setVin(((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getVinList().stream().findFirst().get().getVin());
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setUid(((MP_DispatcherBody)loginResponseMessage.getBody()).getUid());
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setToken(((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getToken());
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setMessageID(5);
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventCreationTime((int)Instant.now().getEpochSecond());
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setApplicationDataProtocolVersion(768);
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventID(0);
        String chargingStatusRequestMessage = new MessageCoder<IASN1PreparedElement>(IASN1PreparedElement.class).encodeRequest(chargingStatusMessage);
        System.out.println("Sending initial chargingStatusRequestMessage to wake the car...");
        String chargingStatusResponse = GetData.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv30");
        AbstractMessage chargingStatusResponseMessage = new MessageCoder<OTA_ChrgMangDataResp>(OTA_ChrgMangDataResp.class).decodeResponse(chargingStatusResponse);
        jsonOuput[1] = GetData.toJSON(chargingStatusResponseMessage);
        ((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventID(((net.heberling.ismart.asn1.v3_0.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getEventID());
        while (chargingStatusResponseMessage.getApplicationData() == null) {
            try {
                System.out.println("Waiting for 6 seconds until the car woke up and responded to our request.");
                Thread.sleep(6000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            GetData.fillReserved(chargingStatusMessage);
            jsonOuput[2] = GetData.toJSON(chargingStatusMessage);
            chargingStatusRequestMessage = new MessageCoder<IASN1PreparedElement>(IASN1PreparedElement.class).encodeRequest(chargingStatusMessage);
            chargingStatusResponse = GetData.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv30");
            chargingStatusResponseMessage = new MessageCoder<OTA_ChrgMangDataResp>(OTA_ChrgMangDataResp.class).decodeResponse(chargingStatusResponse);
            jsonOuput[3] = GetData.toJSON(chargingStatusResponseMessage);
        }
        System.out.println("We got a response.");
        return jsonOuput;
    }

    private static void fillReserved(net.heberling.ismart.asn1.v3_0.Message<IASN1PreparedElement> chargingStatusMessage) {
        System.arraycopy((new Random(System.currentTimeMillis()).nextLong() + "1111111111111111").getBytes(), 0, chargingStatusMessage.getReserved(), 0, 16);
    }

    private static String sendRequest(String request, String endpoint) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(endpoint);
            httppost.setEntity(new StringEntity(request, ContentType.TEXT_HTML));
            HttpClientResponseHandler<String> responseHandler = response -> {
                int status = response.getCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    try {
                        return entity != null ? EntityUtils.toString(entity) : null;
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException(ex);
                    }
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            String string = httpclient.execute((ClassicHttpRequest)httppost, responseHandler);
            return string;
        }
    }

    public static <H extends IASN1PreparedElement, B extends IASN1PreparedElement, E extends IASN1PreparedElement, M extends AbstractMessage<H, B, E>> String toJSON(M message) {
        String json = new GensonBuilder().useIndentation(true).useRuntimeType(true).exclude("preparedData").withConverterFactory(new ChainedFactory(){

            @Override
            protected Converter<?> create(Type type, Genson genson, Converter<?> converter) {
                final Class<?> clazz = TypeUtil.getRawClass(type);
                if (clazz.isAnnotationPresent(ASN1Enum.class)) {
                    return new Converter<Object>(){

                        @Override
                        public void serialize(Object o, ObjectWriter objectWriter, Context context) throws Exception {
                            Method getValue = clazz.getMethod("getValue", new Class[0]);
                            Object value = getValue.invoke(o, new Object[0]);
                            if (value == null) {
                                objectWriter.writeNull();
                            } else {
                                objectWriter.writeString(String.valueOf(value));
                            }
                        }

                        @Override
                        public Object deserialize(ObjectReader objectReader, Context context) throws Exception {
                            throw new UnsupportedOperationException("not implemented yet");
                        }
                    };
                }
                return converter;
            }
        }).create().serialize(message);
        return json;
    }
}

