/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bn.annotations.ASN1Any;
import org.bn.annotations.ASN1BoxedType;
import org.bn.annotations.ASN1Element;
import org.bn.annotations.ASN1Enum;
import org.bn.annotations.ASN1Null;
import org.bn.annotations.ASN1Sequence;
import org.bn.annotations.ASN1SequenceOf;
import org.bn.annotations.ASN1String;
import org.bn.annotations.constraints.ASN1SizeConstraint;
import org.bn.annotations.constraints.ASN1ValueRangeConstraint;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1PreparedElement;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.metadata.ASN1AnyMetadata;
import org.bn.metadata.ASN1NullMetadata;
import org.bn.metadata.ASN1SequenceMetadata;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.metadata.ASN1StringMetadata;
import org.bn.types.BitString;

public class CoderUtils {
    private CoderUtils() {
    }

    public static int getIntegerLength(int value) {
        int sizeOfInt;
        long mask = 2139095040L;
        if (value < 0) {
            for (sizeOfInt = 4; (mask & (long)value) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
        } else {
            while ((mask & (long)value) == 0L && sizeOfInt > 1) {
                mask >>= 8;
                --sizeOfInt;
            }
        }
        return sizeOfInt;
    }

    public static int getIntegerLength(long value) {
        int sizeOfInt;
        long mask = 9187343239835811840L;
        if (value < 0L) {
            for (sizeOfInt = 8; (mask & value) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
        } else {
            while ((mask & value) == 0L && sizeOfInt > 1) {
                mask >>= 8;
                --sizeOfInt;
            }
        }
        return sizeOfInt;
    }

    public static int getPositiveIntegerLength(int value) {
        if (value < 0) {
            int sizeOfInt;
            long mask = 2139095040L;
            for (sizeOfInt = 4; (mask & (long)(~value)) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
            return sizeOfInt;
        }
        return CoderUtils.getIntegerLength(value);
    }

    public static int getPositiveIntegerLength(long value) {
        if (value < 0L) {
            int sizeOfInt;
            long mask = 9187343239835811840L;
            for (sizeOfInt = 8; (mask & (value ^ 0xFFFFFFFFFFFFFFFFL)) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
            return sizeOfInt;
        }
        return CoderUtils.getIntegerLength(value);
    }

    public static BitString defStringToOctetString(String bhString) {
        if (bhString.length() < 4) {
            return new BitString();
        }
        if (bhString.lastIndexOf(66) == bhString.length() - 1) {
            return CoderUtils.bitStringToOctetString(bhString.substring(1, bhString.length() - 2));
        }
        return CoderUtils.hexStringToOctetString(bhString.substring(1, bhString.length() - 2));
    }

    private static BitString bitStringToOctetString(String bhString) {
        boolean hasTrailBits = bhString.length() % 2 != 0;
        int trailBits = 0;
        byte[] resultBuf = new byte[bhString.length() / 8 + (hasTrailBits ? 1 : 0)];
        int currentStrPos = 0;
        for (int i = 0; i < resultBuf.length; ++i) {
            int bitCnt;
            byte bt = 0;
            for (bitCnt = currentStrPos; bitCnt < currentStrPos + 8 && bitCnt < bhString.length(); ++bitCnt) {
                if (bhString.charAt(bitCnt) == '0') continue;
                bt = (byte)(bt | 1 << 7 - (bitCnt - currentStrPos));
            }
            if (bitCnt != (currentStrPos += 8)) {
                trailBits = 8 - (currentStrPos - bitCnt);
            }
            resultBuf[i] = bt;
        }
        BitString result = new BitString(resultBuf, trailBits);
        return result;
    }

    private static BitString hexStringToOctetString(String bhString) {
        boolean hasTrailBits = bhString.length() % 2 != 0;
        BitString result = new BitString(new byte[bhString.length() / 2 + (hasTrailBits ? 1 : 0)], hasTrailBits ? 4 : 0);
        byte[] hex = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        for (int i = 0; i < result.getLength(); ++i) {
            result.getValue()[i] = (byte)(hex[bhString.charAt(i * 2) - 48] << 4);
            if (hasTrailBits && (!hasTrailBits || i >= result.getLength() - 1)) continue;
            byte[] byArray = result.getValue();
            int n = i;
            byArray[n] = (byte)(byArray[n] | (byte)(hex[bhString.charAt(i * 2 + 1) - 48] & 0xF));
        }
        return result;
    }

    public static SortedMap<Integer, Field> getSetOrder(Class<?> objectClass) {
        TreeMap<Integer, Field> fieldOrder = new TreeMap<Integer, Field>();
        int tagNA = -1;
        for (Field field : objectClass.getDeclaredFields()) {
            ASN1Element element = field.getAnnotation(ASN1Element.class);
            if (element == null) continue;
            if (element.hasTag()) {
                fieldOrder.put(element.tag(), field);
                continue;
            }
            fieldOrder.put(tagNA--, field);
        }
        return fieldOrder;
    }

    public static int getStringTagForElement(ElementInfo elementInfo) {
        int result = 19;
        if (elementInfo.hasPreparedInfo()) {
            result = ((ASN1StringMetadata)elementInfo.getPreparedInfo().getTypeMetadata()).getStringType();
        } else if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1String.class)) {
            ASN1String value = elementInfo.getAnnotatedClass().getAnnotation(ASN1String.class);
            result = value.stringType();
        } else if (elementInfo.getParentAnnotated() != null && elementInfo.getParentAnnotated().isAnnotationPresent(ASN1String.class)) {
            ASN1String value = elementInfo.getParentAnnotated().getAnnotation(ASN1String.class);
            result = value.stringType();
        }
        return result;
    }

    public static void checkConstraints(long value, ElementInfo elementInfo) throws Exception {
        if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.getPreparedInfo().hasConstraint() && !elementInfo.getPreparedInfo().getConstraint().checkValue(value)) {
                throw new Exception("Value of '" + elementInfo.getAnnotatedClass().toString() + "' out of bounds");
            }
        } else {
            Annotation constraint;
            if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ValueRangeConstraint.class) && (value > (constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1ValueRangeConstraint.class)).max() || value < constraint.min())) {
                throw new Exception("Value of '" + elementInfo.getAnnotatedClass().toString() + "' out of bounds");
            }
            if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1SizeConstraint.class) && value != (constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1SizeConstraint.class)).max()) {
                throw new Exception("Value of '" + elementInfo.getAnnotatedClass().toString() + "' out of bounds");
            }
        }
    }

    public static boolean isAnyField(Field field, ElementInfo elementInfo) {
        return elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().getTypeMetadata() instanceof ASN1AnyMetadata : field.isAnnotationPresent(ASN1Any.class);
    }

    public static boolean isNullField(Field field, ElementInfo elementInfo) {
        return elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().getTypeMetadata() instanceof ASN1NullMetadata : field.isAnnotationPresent(ASN1Null.class);
    }

    public static boolean isOptionalField(Field field, ElementInfo elementInfo) {
        if (elementInfo.hasPreparedInfo()) {
            return elementInfo.hasPreparedASN1ElementInfo() && (elementInfo.getPreparedASN1ElementInfo().isOptional() || elementInfo.getPreparedASN1ElementInfo().hasDefaultValue());
        }
        if (field.isAnnotationPresent(ASN1Element.class)) {
            ASN1Element info = field.getAnnotation(ASN1Element.class);
            return info.isOptional() || info.hasDefaultValue();
        }
        return false;
    }

    public static boolean isDefaultField(Field field, ElementInfo elementInfo) {
        if (elementInfo.hasPreparedInfo()) {
            return elementInfo.hasPreparedASN1ElementInfo() && elementInfo.getPreparedASN1ElementInfo().hasDefaultValue();
        }
        if (field.isAnnotationPresent(ASN1Element.class)) {
            return field.getAnnotation(ASN1Element.class).hasDefaultValue();
        }
        return false;
    }

    public static boolean isOptional(ElementInfo elementInfo) {
        if (elementInfo.hasPreparedInfo()) {
            return elementInfo.getPreparedASN1ElementInfo().isOptional() || elementInfo.getPreparedASN1ElementInfo().hasDefaultValue();
        }
        return elementInfo.getASN1ElementInfo() != null && elementInfo.getASN1ElementInfo().isOptional();
    }

    public static void checkForOptionalField(Field field, ElementInfo elementInfo) throws Exception {
        if (CoderUtils.isOptionalField(field, elementInfo)) {
            return;
        }
        throw new IllegalArgumentException("The mandatory field '" + field.getName() + "' does not have a value!");
    }

    public static boolean isSequenceSet(ElementInfo elementInfo) {
        if (elementInfo.hasPreparedInfo()) {
            return ((ASN1SequenceMetadata)elementInfo.getPreparedInfo().getTypeMetadata()).isSet();
        }
        return elementInfo.getAnnotatedClass().getAnnotation(ASN1Sequence.class).isSet();
    }

    public static boolean isSequenceSetOf(ElementInfo elementInfo) {
        if (elementInfo.hasPreparedInfo()) {
            return ((ASN1SequenceOfMetadata)elementInfo.getPreparedInfo().getTypeMetadata()).isSetOf();
        }
        return elementInfo.getAnnotatedClass().getAnnotation(ASN1SequenceOf.class).isSetOf();
    }

    public static Method findMethodForField(String methodName, Class<?> objectClass, Class<?> paramClass) throws NoSuchMethodException {
        try {
            return objectClass.getMethod(methodName, paramClass);
        }
        catch (NoSuchMethodException ex) {
            Method[] methods;
            for (Method method : methods = objectClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
            throw ex;
        }
    }

    public static Method findSetterMethodForField(Field field, Class<?> objectClass, Class<?> paramClass) throws NoSuchMethodException {
        String methodName = "set" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        return CoderUtils.findMethodForField(methodName, objectClass, paramClass);
    }

    public static Method findDoSelectMethodForField(Field field, Class<?> objectClass, Class<?> paramClass) throws NoSuchMethodException {
        String methodName = "select" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        return CoderUtils.findMethodForField(methodName, objectClass, paramClass);
    }

    public static Method findGetterMethodForField(Field field, Class<?> objectClass) throws NoSuchMethodException {
        String getterMethodName = "get" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        return objectClass.getMethod(getterMethodName, null);
    }

    public static Method findIsSelectedMethodForField(Field field, Class<?> objectClass) throws NoSuchMethodException {
        String methodName = "is" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1) + "Selected";
        return objectClass.getMethod(methodName, null);
    }

    public static boolean isMemberClass(Class<?> objectClass, ElementInfo elementInfo) {
        return elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().isMemberClass() : objectClass.isMemberClass();
    }

    public static byte[] ASN1StringToBuffer(Object obj, ElementInfo elementInfo) throws UnsupportedEncodingException {
        int stringTag = CoderUtils.getStringTagForElement(elementInfo);
        if (stringTag == 12) {
            return obj.toString().getBytes("utf-8");
        }
        if (stringTag == 30) {
            return obj.toString().getBytes("UnicodeBigUnmarked");
        }
        return obj.toString().getBytes();
    }

    public static String bufferToASN1String(byte[] byteBuf, ElementInfo elementInfo) throws UnsupportedEncodingException {
        int stringTag = CoderUtils.getStringTagForElement(elementInfo);
        if (stringTag == 12) {
            return new String(byteBuf, "utf-8");
        }
        if (stringTag == 30) {
            return new String(byteBuf, "UnicodeBigUnmarked");
        }
        return new String(byteBuf);
    }

    public static Class<?> getCollectionType(ElementInfo elementInfo) {
        ParameterizedType tp = (ParameterizedType)elementInfo.getGenericInfo();
        return CoderUtils.getCollectionType(tp);
    }

    public static Class<?> getCollectionType(ParameterizedType tp) {
        Class<byte[]> paramType;
        Type tpParam = tp.getActualTypeArguments()[0];
        if (tpParam instanceof GenericArrayType) {
            paramType = (Class<byte[]>)((Object)((GenericArrayType)tpParam).getGenericComponentType());
            if (paramType.equals(Byte.TYPE)) {
                paramType = byte[].class;
            }
        } else {
            paramType = (Class)tp.getActualTypeArguments()[0];
        }
        return paramType;
    }

    public static void initDefaultValues(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (object instanceof IASN1PreparedElement) {
            ((IASN1PreparedElement)object).initWithDefaults();
        } else {
            Method method = object.getClass().getMethod("initWithDefaults", new Class[0]);
            method.invoke(object, new Object[0]);
        }
    }

    public static boolean equals(Object obj1, Object obj2) throws ReflectiveOperationException {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null && obj2 != null || obj1 != null && obj2 == null) {
            return false;
        }
        if (obj1 instanceof byte[] && obj2 instanceof byte[]) {
            return Arrays.equals((byte[])obj1, (byte[])obj2);
        }
        if (obj1 instanceof Collection && obj2 instanceof Collection) {
            if (((Collection)obj1).size() != ((Collection)obj2).size()) {
                return false;
            }
            Iterator it1 = ((Iterable)obj1).iterator();
            Iterator it2 = ((Iterable)obj2).iterator();
            while (it1.hasNext()) {
                if (CoderUtils.equals(it1.next(), it2.next())) continue;
                return false;
            }
            return true;
        }
        if ((obj1.getClass().isAnnotationPresent(ASN1BoxedType.class) || obj1.getClass().isAnnotationPresent(ASN1Enum.class)) && obj1.getClass().equals(obj2.getClass())) {
            Method getValueMethod = obj1.getClass().getMethod("getValue", new Class[0]);
            return CoderUtils.equals(getValueMethod.invoke(obj1, new Object[0]), getValueMethod.invoke(obj2, new Object[0]));
        }
        if (obj1.getClass().isAnnotationPresent(ASN1Sequence.class) && obj1.getClass().equals(obj2.getClass())) {
            for (Field field : obj1.getClass().getDeclaredFields()) {
                Object fieldValue2;
                Object fieldValue1;
                if (field.isSynthetic() || field.getType().equals(IASN1PreparedElementData.class) || CoderUtils.equals(fieldValue1 = CoderUtils.findGetterMethodForField(field, obj1.getClass()).invoke(obj1, new Object[0]), fieldValue2 = CoderUtils.findGetterMethodForField(field, obj1.getClass()).invoke(obj2, new Object[0]))) continue;
                return false;
            }
            return true;
        }
        return obj1.equals(obj2);
    }
}

