/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.per;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.SortedMap;
import org.bn.annotations.ASN1EnumItem;
import org.bn.annotations.constraints.ASN1SizeConstraint;
import org.bn.annotations.constraints.ASN1ValueRangeConstraint;
import org.bn.coders.CoderUtils;
import org.bn.coders.ElementInfo;
import org.bn.coders.Encoder;
import org.bn.coders.ber.BERObjectIdentifier;
import org.bn.coders.per.PERCoderUtils;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.metadata.constraints.ASN1SizeConstraintMetadata;
import org.bn.metadata.constraints.ASN1ValueRangeConstraintMetadata;
import org.bn.metadata.constraints.IASN1ConstraintMetadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;
import org.bn.utils.BitArrayOutputStream;

public class PERAlignedEncoder
extends Encoder {
    @Override
    public void encode(Object object, OutputStream stream) throws Exception {
        BitArrayOutputStream bitStream = new BitArrayOutputStream();
        super.encode(object, bitStream);
        bitStream.writeTo(stream);
    }

    protected void doAlign(OutputStream stream) {
        ((BitArrayOutputStream)stream).align();
    }

    protected int encodeIntegerValueAsBytes(long value, OutputStream stream) throws Exception {
        int integerSize = CoderUtils.getIntegerLength(value);
        for (int i = integerSize - 1; i >= 0; --i) {
            long valueTmp = value >> 8 * i;
            stream.write((int)(valueTmp & 0xFFL));
        }
        return integerSize;
    }

    protected int encodeConstraintLengthDeterminant(int length, int min, int max, BitArrayOutputStream stream) throws Exception {
        if (max <= 65535) {
            return this.encodeConstraintNumber(length, min, max, stream);
        }
        return this.encodeLengthDeterminant(length, stream);
    }

    protected int encodeLengthDeterminant(int length, BitArrayOutputStream stream) throws IOException {
        int result = 0;
        this.doAlign(stream);
        if (length >= 0 && length < 128) {
            stream.write(length);
            result = 1;
        } else if (length < 16384) {
            stream.write(length >>> 8 & 0x3F | 0x80);
            stream.write(length);
            result = 2;
        } else {
            throw new InternalError("Not supported for this version. Length too big!");
        }
        return result;
    }

    protected int encodeConstraintNumber(long value, long min, long max, BitArrayOutputStream stream) throws Exception {
        int result = 0;
        long valueRange = max - min;
        long narrowedVal = value - min;
        int maxBitLen = PERCoderUtils.getMaxBitLength(valueRange);
        if (valueRange == 0L) {
            return result;
        }
        if (valueRange > 0L && valueRange < 256L) {
            this.doAlign(stream);
            for (int i = maxBitLen - 1; i >= 0; --i) {
                int bitValue = (int)(narrowedVal >> i & 1L);
                stream.writeBit(bitValue);
            }
            result = 1;
        } else if (valueRange > 0L && valueRange < 65536L) {
            this.doAlign(stream);
            stream.write((int)(narrowedVal >>> 8));
            stream.write((int)(narrowedVal & 0xFFL));
            result = 2;
        } else {
            result = this.encodeConstraintLengthDeterminant(CoderUtils.getIntegerLength(narrowedVal), 1, CoderUtils.getPositiveIntegerLength(valueRange), stream);
            this.doAlign(stream);
            result += this.encodeIntegerValueAsBytes(narrowedVal, stream);
        }
        return result;
    }

    protected int encodeSemiConstraintNumber(int value, int min, BitArrayOutputStream stream) throws Exception {
        int result = 0;
        int narrowedVal = value - min;
        int intLen = CoderUtils.getIntegerLength(narrowedVal);
        result += this.encodeLengthDeterminant(intLen, stream);
        this.doAlign(stream);
        return result += this.encodeIntegerValueAsBytes(narrowedVal, stream);
    }

    protected int encodeNormallySmallNumber(int value, BitArrayOutputStream stream) throws Exception {
        int result = 0;
        if (value > 0 && value < 64) {
            stream.writeBit(0);
            for (int i = 0; i < 6; ++i) {
                int bitValue = value >> 6 - i & 1;
                stream.writeBit(bitValue);
            }
            result = 1;
        } else {
            stream.writeBit(1);
            result += this.encodeSemiConstraintNumber(value, 0, stream);
        }
        return result;
    }

    protected int encodeUnconstraintNumber(long value, BitArrayOutputStream stream) throws Exception {
        int result = 0;
        int intLen = CoderUtils.getIntegerLength(value);
        result += this.encodeLengthDeterminant(intLen, stream);
        this.doAlign(stream);
        return result += this.encodeIntegerValueAsBytes(value, stream);
    }

    @Override
    public int encodeInteger(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        Number value;
        Object constraint;
        int result = 0;
        boolean hasConstraint = false;
        long min = 0L;
        long max = 0L;
        if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.getPreparedInfo().hasConstraint() && elementInfo.getPreparedInfo().getConstraint() instanceof ASN1ValueRangeConstraintMetadata) {
                constraint = elementInfo.getPreparedInfo().getConstraint();
                hasConstraint = true;
                min = ((ASN1ValueRangeConstraintMetadata)constraint).getMin();
                max = ((ASN1ValueRangeConstraintMetadata)constraint).getMax();
            }
        } else if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ValueRangeConstraint.class)) {
            hasConstraint = true;
            constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1ValueRangeConstraint.class);
            min = constraint.min();
            max = constraint.max();
        }
        if (object instanceof Integer) {
            value = (Integer)object;
            BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
            result = hasConstraint ? (result += this.encodeConstraintNumber(((Integer)value).intValue(), (int)min, (int)max, bitStream)) : (result += this.encodeUnconstraintNumber(((Integer)value).intValue(), bitStream));
        } else {
            value = (Long)object;
            BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
            result = hasConstraint ? (result += this.encodeConstraintNumber((Long)value, min, max, bitStream)) : (result += this.encodeUnconstraintNumber((Long)value, bitStream));
        }
        return result;
    }

    @Override
    public int encodeReal(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int result = 0;
        BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
        Double value = (Double)object;
        long asLong = Double.doubleToLongBits(value);
        if (asLong == 0x7FF0000000000000L) {
            result += this.encodeLengthDeterminant(1, bitStream);
            this.doAlign(stream);
            stream.write(64);
            ++result;
        } else if (asLong == -4503599627370496L) {
            result += this.encodeLengthDeterminant(1, bitStream);
            this.doAlign(stream);
            stream.write(65);
            ++result;
        } else if (asLong != 0L) {
            long exponent = ((0x7FF0000000000000L & asLong) >> 52) - 1023L - 52L;
            long mantissa = 0xFFFFFFFFFFFFFL & asLong;
            mantissa |= 0x10000000000000L;
            while ((mantissa & 0xFFL) == 0L) {
                mantissa >>= 8;
                exponent += 8L;
            }
            while ((mantissa & 1L) == 0L) {
                mantissa >>= 1;
                ++exponent;
            }
            int szOfExp = CoderUtils.getIntegerLength(exponent);
            this.encodeLengthDeterminant(CoderUtils.getIntegerLength(mantissa) + szOfExp + 1, bitStream);
            this.doAlign(stream);
            int realPreamble = 0x80 | (byte)(szOfExp - 1);
            if ((asLong & Long.MIN_VALUE) == Long.MIN_VALUE) {
                realPreamble |= 0x40;
            }
            stream.write(realPreamble);
            ++result;
            result += this.encodeIntegerValueAsBytes(exponent, stream);
            result += this.encodeIntegerValueAsBytes(mantissa, stream);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int encodeLength(int value, ElementInfo elementInfo, OutputStream stream) throws Exception {
        int resultSize = 0;
        BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
        CoderUtils.checkConstraints(value, elementInfo);
        if (elementInfo.hasPreparedInfo()) {
            if (!elementInfo.getPreparedInfo().hasConstraint()) {
                return resultSize += this.encodeLengthDeterminant(value, bitStream);
            }
            IASN1ConstraintMetadata constraint = elementInfo.getPreparedInfo().getConstraint();
            if (constraint instanceof ASN1ValueRangeConstraintMetadata) {
                return resultSize += this.encodeConstraintLengthDeterminant(value, (int)((ASN1ValueRangeConstraintMetadata)constraint).getMin(), (int)((ASN1ValueRangeConstraintMetadata)constraint).getMax(), bitStream);
            }
            if (!(constraint instanceof ASN1SizeConstraintMetadata)) return resultSize;
            return resultSize;
        } else {
            if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ValueRangeConstraint.class)) {
                ASN1ValueRangeConstraint constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1ValueRangeConstraint.class);
                return resultSize += this.encodeConstraintLengthDeterminant(value, (int)constraint.min(), (int)constraint.max(), bitStream);
            }
            if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1SizeConstraint.class)) {
                ASN1SizeConstraint aSN1SizeConstraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1SizeConstraint.class);
                return resultSize;
            }
            resultSize += this.encodeLengthDeterminant(value, bitStream);
        }
        return resultSize;
    }

    protected int encodeSequencePreamble(Object object, Field[] fields, ElementInfo elementInfo, OutputStream stream) throws Exception {
        int resultBitSize = 0;
        ElementInfo info = new ElementInfo();
        int fieldIdx = 0;
        for (Field field : fields) {
            if (field.isSynthetic()) continue;
            if (elementInfo.hasPreparedInfo()) {
                info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
            }
            if (CoderUtils.isOptionalField(field, info)) {
                Object invokeObjResult = this.invokeGetterMethodForField(field, object, info);
                if (invokeObjResult == null) {
                    ((BitArrayOutputStream)stream).writeBit(false);
                } else if (CoderUtils.isDefaultField(field, info)) {
                    Object newSequenceInstance = elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().newInstance() : object.getClass().newInstance();
                    CoderUtils.initDefaultValues(newSequenceInstance);
                    Object defaultFieldValue = this.invokeGetterMethodForField(field, newSequenceInstance, info);
                    ((BitArrayOutputStream)stream).writeBit(!CoderUtils.equals(defaultFieldValue, invokeObjResult));
                } else {
                    ((BitArrayOutputStream)stream).writeBit(true);
                }
                ++resultBitSize;
            }
            ++fieldIdx;
        }
        this.doAlign(stream);
        return resultBitSize / 8 + (resultBitSize % 8 > 0 ? 1 : 0);
    }

    @Override
    public int encodeSequence(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        if (!CoderUtils.isSequenceSet(elementInfo)) {
            resultSize += this.encodeSequencePreamble(object, elementInfo.getFields(object.getClass()), elementInfo, stream);
            resultSize += super.encodeSequence(object, stream, elementInfo);
        } else {
            resultSize += this.encodeSet(object, stream, elementInfo);
        }
        return resultSize;
    }

    protected int encodeChoicePreamble(Object object, OutputStream stream, int elementIndex, ElementInfo elementInfo) throws Exception {
        return this.encodeConstraintNumber(elementIndex, 1L, PERCoderUtils.getRealFieldsCount(object.getClass(), elementInfo), (BitArrayOutputStream)stream);
    }

    @Override
    public int encodeChoice(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        this.doAlign(stream);
        ElementInfo info = null;
        int elementIndex = 0;
        int fieldIdx = 0;
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            ++elementIndex;
            info = new ElementInfo();
            info.setAnnotatedClass(field);
            if (elementInfo.hasPreparedInfo()) {
                info.setPreparedInfo(elementInfo.getPreparedInfo().getFieldMetadata(fieldIdx));
            } else {
                info.setASN1ElementInfoForClass(field);
            }
            if (this.isSelectedChoiceItem(field, object, info)) break;
            info = null;
            ++fieldIdx;
        }
        if (info == null) {
            throw new IllegalArgumentException("The choice '" + object.toString() + "' does not have a selected item!");
        }
        Object invokeObjResult = this.invokeGetterMethodForField((Field)info.getAnnotatedClass(), object, info);
        resultSize += this.encodeChoicePreamble(object, stream, elementIndex, elementInfo);
        return resultSize += this.encodeClassType(invokeObjResult, stream, info);
    }

    @Override
    public int encodeEnumItem(Object enumConstant, Class enumClass, OutputStream stream, ElementInfo elementInfo) throws Exception {
        ASN1EnumItem enumObj = elementInfo.getAnnotatedClass().getAnnotation(ASN1EnumItem.class);
        int min = 0;
        int max = 0;
        int value = 0;
        for (Field enumItem : enumClass.getDeclaredFields()) {
            if (!enumItem.isAnnotationPresent(ASN1EnumItem.class)) continue;
            ASN1EnumItem enumItemObj = enumItem.getAnnotation(ASN1EnumItem.class);
            if (enumItemObj.tag() == enumObj.tag()) {
                value = max;
            }
            ++max;
        }
        if (max > 0) {
            return this.encodeConstraintNumber(value, min, max - 1, (BitArrayOutputStream)stream);
        }
        throw new Exception("Unable to present any enum item!");
    }

    @Override
    public int encodeBoolean(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 1;
        BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
        bitStream.writeBit((Boolean)object);
        return resultSize;
    }

    @Override
    public int encodeAny(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        byte[] buffer = (byte[])object;
        stream.write(buffer);
        return buffer.length;
    }

    @Override
    public int encodeOctetString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        byte[] buffer = (byte[])object;
        int sizeOfString = buffer.length;
        int resultSize = this.encodeLength(sizeOfString, elementInfo, stream);
        this.doAlign(stream);
        if (sizeOfString > 0) {
            stream.write(buffer);
        }
        return resultSize;
    }

    @Override
    public int encodeBitString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        BitString str = (BitString)object;
        byte[] buffer = str.getValue();
        int sizeOfString = str.getLengthInBits();
        BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
        int resultSize = this.encodeLength(sizeOfString, elementInfo, stream);
        this.doAlign(stream);
        if (sizeOfString > 0) {
            if (str.getTrailBitsCnt() == 0) {
                stream.write(buffer);
            } else {
                bitStream.write(buffer, 0, buffer.length - 1);
                for (int i = 0; i < str.getTrailBitsCnt(); ++i) {
                    int bitValue = buffer[buffer.length - 1] >> 7 - i & 1;
                    bitStream.writeBit(bitValue);
                }
            }
        }
        return resultSize;
    }

    @Override
    public int encodeString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        byte[] value = CoderUtils.ASN1StringToBuffer(object, elementInfo);
        int resultSize = this.encodeLength(value.length, elementInfo, stream);
        this.doAlign(stream);
        resultSize += value.length;
        if (value.length > 0) {
            stream.write(value);
        }
        return resultSize;
    }

    @Override
    public int encodeSequenceOf(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        Collection collection = (Collection)object;
        int resultSize = this.encodeLength(collection.size(), elementInfo, stream);
        for (Object obj : collection) {
            ElementInfo info = new ElementInfo();
            info.setAnnotatedClass(obj.getClass());
            info.setParentAnnotated(elementInfo.getAnnotatedClass());
            if (elementInfo.hasPreparedInfo()) {
                ASN1SequenceOfMetadata seqOfMeta = (ASN1SequenceOfMetadata)elementInfo.getPreparedInfo().getTypeMetadata();
                info.setPreparedInfo(seqOfMeta.getItemClassMetadata());
            }
            resultSize += this.encodeClassType(obj, stream, info);
        }
        return resultSize;
    }

    @Override
    public int encodeNull(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        return 0;
    }

    protected int encodeSet(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        Field[] fields;
        if (elementInfo.hasPreparedInfo()) {
            fields = elementInfo.getPreparedInfo().getFields();
        } else {
            SortedMap<Integer, Field> fieldOrder = CoderUtils.getSetOrder(object.getClass());
            fields = fieldOrder.values().toArray(new Field[fieldOrder.size()]);
        }
        int resultSize = this.encodeSequencePreamble(object, fields, elementInfo, stream);
        int fieldIdx = 0;
        for (Field field : fields) {
            resultSize += this.encodeSequenceField(object, fieldIdx++, field, stream, elementInfo);
        }
        return resultSize;
    }

    @Override
    public int encodeObjectIdentifier(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        ObjectIdentifier oid = (ObjectIdentifier)object;
        int[] ia = oid.getIntArray();
        byte[] buffer = BERObjectIdentifier.Encode(ia);
        if (buffer.length < 1) {
            return 0;
        }
        int resultSize = 0;
        resultSize += this.encodeLength(buffer.length, elementInfo, stream);
        stream.write(buffer, 0, buffer.length);
        return resultSize += buffer.length;
    }
}

