/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.per;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.bn.coders.CoderUtils;
import org.bn.coders.ElementInfo;

public class PERCoderUtils {
    public static int getMaxBitLength(long value) {
        int bitCnt = 0;
        while (value != 0L) {
            value >>>= 1;
            ++bitCnt;
        }
        return bitCnt;
    }

    public static int getRealFieldsCount(Class objectClass, ElementInfo info) {
        int result = 0;
        if (info.hasPreparedInfo()) {
            result = info.getPreparedInfo().getFields().length;
        } else {
            for (Field item : objectClass.getDeclaredFields()) {
                if (item.isSynthetic()) continue;
                ++result;
            }
        }
        return result;
    }

    public static List<Field> getRealFields(Class objectClass) {
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field item : objectClass.getDeclaredFields()) {
            if (item.isSynthetic()) continue;
            result.add(item);
        }
        return result;
    }

    public static boolean is7BitEncodedString(ElementInfo elementInfo) {
        int stringType = CoderUtils.getStringTagForElement(elementInfo);
        return stringType == 19 || stringType == 26 || stringType == 22;
    }
}

